/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.monitor;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.monitor.JdbcUrlParsingService;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultJdbcUrlParsingService
implements JdbcUrlParsingService {
    private final JdbcUrlParserV2[] jdbcUrlParsers;
    private final ConcurrentMap<String, DatabaseInfo> cache = new ConcurrentHashMap<String, DatabaseInfo>();
    private final ConcurrentMap<CacheKey, DatabaseInfo> eachServiceTypeCache = new ConcurrentHashMap<CacheKey, DatabaseInfo>();

    public DefaultJdbcUrlParsingService(List<JdbcUrlParserV2> jdbcUrlParsers) {
        Objects.requireNonNull(jdbcUrlParsers, "jdbcUrlParserList");
        this.jdbcUrlParsers = jdbcUrlParsers.toArray(new JdbcUrlParserV2[0]);
    }

    @Override
    public DatabaseInfo getDatabaseInfo(String jdbcUrl) {
        DatabaseInfo databaseInfo = (DatabaseInfo)this.cache.get(jdbcUrl);
        return databaseInfo;
    }

    @Override
    public DatabaseInfo getDatabaseInfo(ServiceType serviceType, String jdbcUrl) {
        CacheKey cacheKey = new CacheKey(serviceType, jdbcUrl);
        DatabaseInfo databaseInfo = (DatabaseInfo)this.eachServiceTypeCache.get(cacheKey);
        if (databaseInfo != null && databaseInfo.isParsingComplete()) {
            return databaseInfo;
        }
        return null;
    }

    @Override
    public DatabaseInfo parseJdbcUrl(ServiceType serviceType, String jdbcUrl) {
        Objects.requireNonNull(serviceType, "serviceType");
        if (jdbcUrl == null) {
            return UnKnownDatabaseInfo.INSTANCE;
        }
        CacheKey cacheKey = new CacheKey(serviceType, jdbcUrl);
        DatabaseInfo cacheValue = (DatabaseInfo)this.eachServiceTypeCache.get(cacheKey);
        if (cacheValue != null) {
            return cacheValue;
        }
        for (JdbcUrlParserV2 parser : this.jdbcUrlParsers) {
            if (parser.getServiceType() == null || serviceType.getCode() != parser.getServiceType().getCode()) continue;
            DatabaseInfo databaseInfo = parser.parse(jdbcUrl);
            return this.putCacheIfAbsent(cacheKey, databaseInfo);
        }
        return this.putCacheIfAbsent(cacheKey, UnKnownDatabaseInfo.createUnknownDataBase((String)jdbcUrl));
    }

    private DatabaseInfo putCacheIfAbsent(CacheKey cacheKey, DatabaseInfo databaseInfo) {
        DatabaseInfo old;
        if (databaseInfo.isParsingComplete()) {
            this.cache.putIfAbsent(cacheKey.getJdbcUrl(), databaseInfo);
        }
        if ((old = this.eachServiceTypeCache.putIfAbsent(cacheKey, databaseInfo)) != null) {
            return old;
        }
        return databaseInfo;
    }

    private static class CacheKey {
        private final ServiceType serviceType;
        private final String jdbcUrl;

        public CacheKey(ServiceType serviceType, String jdbcUrl) {
            this.serviceType = serviceType;
            this.jdbcUrl = jdbcUrl;
        }

        public ServiceType getServiceType() {
            return this.serviceType;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.serviceType != null ? !this.serviceType.equals(cacheKey.serviceType) : cacheKey.serviceType != null) {
                return false;
            }
            return this.jdbcUrl != null ? this.jdbcUrl.equals(cacheKey.jdbcUrl) : cacheKey.jdbcUrl == null;
        }

        public int hashCode() {
            int result = this.serviceType != null ? this.serviceType.hashCode() : 0;
            result = 31 * result + (this.jdbcUrl != null ? this.jdbcUrl.hashCode() : 0);
            return result;
        }
    }
}

