/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.module.config.DeadlockMonitorEnable;
import com.navercorp.pinpoint.profiler.context.module.config.DeadlockMonitorInterval;
import com.navercorp.pinpoint.profiler.monitor.DeadlockMonitor;
import com.navercorp.pinpoint.profiler.monitor.DeadlockThreadRegistry;
import com.navercorp.pinpoint.profiler.monitor.DefaultDeadlockMonitor;
import com.navercorp.pinpoint.profiler.monitor.DisabledDeadlockMonitor;

public class DeadlockMonitorProvider
implements Provider<DeadlockMonitor> {
    private final boolean deadlockMonitorEnable;
    private final DeadlockThreadRegistry deadlockThreadRegistry;
    private final long deadlockMonitorInterval;

    @Inject
    public DeadlockMonitorProvider(@DeadlockMonitorEnable boolean deadlockMonitorEnable, @DeadlockMonitorInterval long deadlockMonitorInterval, DeadlockThreadRegistry deadlockThreadRegistry) {
        this.deadlockMonitorEnable = deadlockMonitorEnable;
        this.deadlockThreadRegistry = deadlockThreadRegistry;
        this.deadlockMonitorInterval = deadlockMonitorInterval;
    }

    public DeadlockMonitor get() {
        if (this.deadlockMonitorEnable) {
            return new DefaultDeadlockMonitor(this.deadlockThreadRegistry, this.deadlockMonitorInterval);
        }
        return new DisabledDeadlockMonitor();
    }
}

