/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.thrift;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.TcpDataSender;
import com.navercorp.pinpoint.profiler.sender.ThriftMessageSerializer;
import com.navercorp.pinpoint.profiler.sender.UdpDataSenderFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;

public class SpanDataSenderProvider
implements Provider<DataSender<SpanType>> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final String UDP_EXECUTOR_NAME = "Pinpoint-UdpSpanDataExecutor";
    private final Provider<PinpointClientFactory> clientFactoryProvider;
    private final String ip;
    private final int port;
    private final int writeQueueSize;
    private final int timeout;
    private final int sendBufferSize;
    private final String ioType;
    private final String transportType;
    private final MessageConverter<SpanType, TBase<?, ?>> messageConverter;

    @Inject
    public SpanDataSenderProvider(ThriftTransportConfig thriftTransportConfig, @SpanDataSender Provider<PinpointClientFactory> clientFactoryProvider, @SpanDataSender MessageConverter<SpanType, TBase<?, ?>> messageConverter) {
        Objects.requireNonNull(thriftTransportConfig, "thriftTransportConfig");
        this.clientFactoryProvider = Objects.requireNonNull(clientFactoryProvider, "clientFactoryProvider");
        this.ip = thriftTransportConfig.getCollectorSpanServerIp();
        this.port = thriftTransportConfig.getCollectorSpanServerPort();
        this.writeQueueSize = thriftTransportConfig.getSpanDataSenderWriteQueueSize();
        this.timeout = thriftTransportConfig.getSpanDataSenderSocketTimeout();
        this.sendBufferSize = thriftTransportConfig.getSpanDataSenderSocketSendBufferSize();
        this.ioType = thriftTransportConfig.getSpanDataSenderSocketType();
        this.transportType = thriftTransportConfig.getSpanDataSenderTransportType();
        this.messageConverter = Objects.requireNonNull(messageConverter, "messageConverter");
    }

    public DataSender<SpanType> get() {
        if ("TCP".equalsIgnoreCase(this.transportType)) {
            if ("OIO".equalsIgnoreCase(this.ioType)) {
                this.logger.warn("TCP transport not support OIO type.(only support NIO)");
            }
            PinpointClientFactory pinpointClientFactory = (PinpointClientFactory)this.clientFactoryProvider.get();
            ThriftMessageSerializer<SpanType> messageSerializer = new ThriftMessageSerializer<SpanType>(this.messageConverter);
            return new TcpDataSender<SpanType>("SpanDataSender", this.ip, this.port, pinpointClientFactory, messageSerializer, this.writeQueueSize);
        }
        UdpDataSenderFactory<SpanType> factory = new UdpDataSenderFactory<SpanType>(this.ip, this.port, UDP_EXECUTOR_NAME, this.writeQueueSize, this.timeout, this.sendBufferSize, this.messageConverter);
        return factory.create(this.ioType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SpanDataSenderProvider{");
        sb.append("ip='").append(this.ip).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", writeQueueSize=").append(this.writeQueueSize);
        sb.append(", timeout=").append(this.timeout);
        sb.append(", sendBufferSize=").append(this.sendBufferSize);
        sb.append(", ioType='").append(this.ioType).append('\'');
        sb.append(", transportType='").append(this.transportType).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

