/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.thrift;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.TcpDataSender;
import com.navercorp.pinpoint.profiler.sender.ThriftMessageSerializer;
import com.navercorp.pinpoint.profiler.sender.UdpDataSenderFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;

public class StatDataSenderProvider
implements Provider<DataSender<MetricType>> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final String UDP_EXECUTOR_NAME = "Pinpoint-UdpStatDataExecutor";
    private final Provider<PinpointClientFactory> clientFactoryProvider;
    private final String ip;
    private final int port;
    private final int writeQueueSize;
    private final int timeout;
    private final int sendBufferSize;
    private final String ioType;
    private final String transportType;
    private final MessageConverter<MetricType, TBase<?, ?>> messageConverter;

    @Inject
    public StatDataSenderProvider(ThriftTransportConfig thriftTransportConfig, @StatDataSender Provider<PinpointClientFactory> clientFactoryProvider, @StatDataSender MessageConverter<MetricType, TBase<?, ?>> messageConverter) {
        Objects.requireNonNull(thriftTransportConfig, "thriftTransportConfig");
        this.clientFactoryProvider = Objects.requireNonNull(clientFactoryProvider, "clientFactoryProvider");
        this.ip = thriftTransportConfig.getCollectorStatServerIp();
        this.port = thriftTransportConfig.getCollectorStatServerPort();
        this.writeQueueSize = thriftTransportConfig.getStatDataSenderWriteQueueSize();
        this.timeout = thriftTransportConfig.getStatDataSenderSocketTimeout();
        this.sendBufferSize = thriftTransportConfig.getStatDataSenderSocketSendBufferSize();
        this.ioType = thriftTransportConfig.getStatDataSenderSocketType();
        this.transportType = thriftTransportConfig.getStatDataSenderTransportType();
        this.messageConverter = messageConverter;
    }

    public DataSender<MetricType> get() {
        if ("TCP".equalsIgnoreCase(this.transportType)) {
            if ("OIO".equalsIgnoreCase(this.ioType)) {
                this.logger.warn("TCP transport not support OIO type.(only support NIO)");
            }
            PinpointClientFactory pinpointClientFactory = (PinpointClientFactory)this.clientFactoryProvider.get();
            ThriftMessageSerializer<MetricType> messageSerializer = new ThriftMessageSerializer<MetricType>(this.messageConverter);
            return new TcpDataSender<MetricType>("StatDataSender", this.ip, this.port, pinpointClientFactory, messageSerializer, this.writeQueueSize);
        }
        UdpDataSenderFactory<MetricType> factory = new UdpDataSenderFactory<MetricType>(this.ip, this.port, UDP_EXECUTOR_NAME, this.writeQueueSize, this.timeout, this.sendBufferSize, this.messageConverter);
        return factory.create(this.ioType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StatDataSenderProvider{");
        sb.append("ip='").append(this.ip).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", writeQueueSize=").append(this.writeQueueSize);
        sb.append(", timeout=").append(this.timeout);
        sb.append(", sendBufferSize=").append(this.sendBufferSize);
        sb.append(", ioType='").append(this.ioType).append('\'');
        sb.append(", transportType='").append(this.transportType).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

