/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector.jvmgc;

import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.JvmGcType;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryMetricSnapshot;
import java.util.Objects;

public class BasicJvmGcMetricCollector
implements AgentStatMetricCollector<JvmGcMetricSnapshot> {
    private final MemoryMetric memoryMetric;
    private final GarbageCollectorMetric garbageCollectorMetric;

    public BasicJvmGcMetricCollector(MemoryMetric memoryMetric, GarbageCollectorMetric garbageCollectorMetric) {
        this.memoryMetric = Objects.requireNonNull(memoryMetric, "memoryMetric");
        this.garbageCollectorMetric = Objects.requireNonNull(garbageCollectorMetric, "garbageCollectorMetric");
    }

    @Override
    public JvmGcMetricSnapshot collect() {
        JvmGcType jvmGcType = this.garbageCollectorMetric.getGcType();
        MemoryMetricSnapshot memoryMetricSnapshot = this.memoryMetric.getSnapshot();
        GarbageCollectorMetricSnapshot garbageCollectorMetricSnapshot = this.garbageCollectorMetric.getSnapshot();
        JvmGcMetricSnapshot jvmGcMetricSnapshot = new JvmGcMetricSnapshot();
        jvmGcMetricSnapshot.setJvmMemoryHeapMax(memoryMetricSnapshot.getHeapMax());
        jvmGcMetricSnapshot.setJvmMemoryHeapUsed(memoryMetricSnapshot.getHeapUsed());
        jvmGcMetricSnapshot.setJvmMemoryNonHeapMax(memoryMetricSnapshot.getNonHeapMax());
        jvmGcMetricSnapshot.setJvmMemoryNonHeapUsed(memoryMetricSnapshot.getNonHeapUsed());
        jvmGcMetricSnapshot.setJvmGcOldCount(garbageCollectorMetricSnapshot.getGcOldCount());
        jvmGcMetricSnapshot.setJvmGcOldTime(garbageCollectorMetricSnapshot.getGcOldTime());
        jvmGcMetricSnapshot.setType(jvmGcType);
        return jvmGcMetricSnapshot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BasicJvmGcMetricCollector{");
        sb.append("memoryMetric=").append(this.memoryMetric);
        sb.append(", garbageCollectorMetric=").append(this.garbageCollectorMetric);
        sb.append('}');
        return sb.toString();
    }
}

