/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver;

import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import com.navercorp.pinpoint.common.util.apache.IntHashMapUtils;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandLocatorBuilder;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.ProfilerRequestCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerSimpleCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerStreamCommandService;
import com.navercorp.pinpoint.profiler.receiver.grpc.ProfilerGrpcCommandService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultProfilerCommandServiceLocator
implements ProfilerCommandServiceLocator {
    private final IntHashMap<ProfilerCommandService> profilerCommandServiceRepository;
    private final Set<Short> codeSet;

    DefaultProfilerCommandServiceLocator(ProfilerCommandLocatorBuilder builder) {
        Map<Short, ProfilerCommandService> commandServiceRepository = builder.getProfilerCommandServiceRepository();
        this.profilerCommandServiceRepository = IntHashMapUtils.copyShortMap(commandServiceRepository);
        this.codeSet = this.buildCodeSet(commandServiceRepository);
    }

    @Override
    public ProfilerCommandService getService(short commandCode) {
        return (ProfilerCommandService)this.profilerCommandServiceRepository.get((int)commandCode);
    }

    public ProfilerSimpleCommandService getSimpleService(short commandCode) {
        ProfilerCommandService service = (ProfilerCommandService)this.profilerCommandServiceRepository.get((int)commandCode);
        if (service instanceof ProfilerSimpleCommandService) {
            return (ProfilerSimpleCommandService)service;
        }
        return null;
    }

    public ProfilerRequestCommandService getRequestService(short commandCode) {
        ProfilerCommandService service = (ProfilerCommandService)this.profilerCommandServiceRepository.get((int)commandCode);
        if (service instanceof ProfilerRequestCommandService) {
            return (ProfilerRequestCommandService)service;
        }
        return null;
    }

    public ProfilerStreamCommandService getStreamService(short commandCode) {
        ProfilerCommandService service = (ProfilerCommandService)this.profilerCommandServiceRepository.get((int)commandCode);
        if (service instanceof ProfilerStreamCommandService) {
            return (ProfilerStreamCommandService)service;
        }
        return null;
    }

    @Override
    public ProfilerGrpcCommandService getGrpcService(short commandCode) {
        ProfilerCommandService service = (ProfilerCommandService)this.profilerCommandServiceRepository.get((int)commandCode);
        if (service instanceof ProfilerGrpcCommandService) {
            return (ProfilerGrpcCommandService)service;
        }
        return null;
    }

    int getCommandServiceSize() {
        return this.profilerCommandServiceRepository.size();
    }

    @Override
    public Set<Short> getCommandServiceCodes() {
        return this.codeSet;
    }

    private Set<Short> buildCodeSet(Map<Short, ProfilerCommandService> codes) {
        return new HashSet<Short>(codes.keySet());
    }
}

