/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.service;

import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceGroup;
import com.navercorp.pinpoint.profiler.receiver.service.ActiveThreadCountService;
import com.navercorp.pinpoint.profiler.receiver.service.ActiveThreadDumpCoreService;
import com.navercorp.pinpoint.profiler.receiver.service.ActiveThreadDumpService;
import com.navercorp.pinpoint.profiler.receiver.service.ActiveThreadLightDumpService;
import java.util.ArrayList;
import java.util.List;

public class ActiveThreadService
implements ProfilerCommandServiceGroup {
    private final List<ProfilerCommandService> serviceList = new ArrayList<ProfilerCommandService>();

    public ActiveThreadService(ThriftTransportConfig thriftTransportConfig, ActiveTraceRepository activeTraceRepository) {
        if (!thriftTransportConfig.isTcpDataSenderCommandActiveThreadEnable()) {
            return;
        }
        if (thriftTransportConfig.isTcpDataSenderCommandActiveThreadCountEnable()) {
            this.serviceList.add(new ActiveThreadCountService(activeTraceRepository));
        }
        ActiveThreadDumpCoreService activeThreadDump = new ActiveThreadDumpCoreService(activeTraceRepository);
        if (thriftTransportConfig.isTcpDataSenderCommandActiveThreadLightDumpEnable()) {
            this.serviceList.add(new ActiveThreadLightDumpService(activeThreadDump));
        }
        if (thriftTransportConfig.isTcpDataSenderCommandActiveThreadDumpEnable()) {
            this.serviceList.add(new ActiveThreadDumpService(activeThreadDump));
        }
    }

    @Override
    public List<ProfilerCommandService> getCommandServiceList() {
        return this.serviceList;
    }
}

