/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.ArrayUtils;

public class RetryMessage {
    private int retryCount = 0;
    private final int maxRetryCount;
    private final byte[] bytes;
    private final Object message;
    private final String messageDescription;

    public RetryMessage(int maxRetryCount, byte[] bytes) {
        this(0, maxRetryCount, bytes, null, "");
    }

    public RetryMessage(int retryCount, int maxRetryCount, byte[] bytes) {
        this(retryCount, maxRetryCount, bytes, null, "");
    }

    public RetryMessage(int maxRetryCount, byte[] bytes, String messageDescription) {
        this(0, maxRetryCount, bytes, null, messageDescription);
    }

    public RetryMessage(int retryCount, int maxRetryCount, byte[] bytes, String messageDescription) {
        this(retryCount, maxRetryCount, bytes, null, messageDescription);
    }

    public RetryMessage(int maxRetryCount, Object message) {
        this(0, maxRetryCount, null, message, "");
    }

    public RetryMessage(int retryCount, int maxRetryCount, Object message) {
        this(retryCount, maxRetryCount, null, message, "");
    }

    public RetryMessage(int maxRetryCount, Object message, String messageDescription) {
        this(0, maxRetryCount, null, message, messageDescription);
    }

    public RetryMessage(int retryCount, int maxRetryCount, Object message, String messageDescription) {
        this(retryCount, maxRetryCount, null, message, messageDescription);
    }

    public RetryMessage(int retryCount, int maxRetryCount, byte[] bytes, Object message, String messageDescription) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("retryCount:" + retryCount + " must be positive number");
        }
        if (maxRetryCount < 0) {
            throw new IllegalArgumentException("maxRetryCount:" + maxRetryCount + " must be positive number");
        }
        if (retryCount > maxRetryCount) {
            throw new IllegalArgumentException("maxRetryCount(" + maxRetryCount + ") must be greater than retryCount(" + retryCount + ")");
        }
        this.retryCount = retryCount;
        this.maxRetryCount = maxRetryCount;
        this.bytes = bytes;
        this.message = message;
        this.messageDescription = messageDescription;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public boolean isRetryAvailable() {
        return this.retryCount < this.maxRetryCount;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int fail() {
        return ++this.retryCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RetryMessage{");
        sb.append("retryCount=").append(this.retryCount);
        sb.append(", maxRetryCount=").append(this.maxRetryCount);
        sb.append(", bytes=").append(ArrayUtils.getLength((byte[])this.bytes, (int)-1));
        sb.append(", messageDescription='").append(this.messageDescription).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

