/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.clientinterface;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.test.util.RandomUtil;
import org.apache.rocketmq.test.util.data.collect.DataCollector;
import org.apache.rocketmq.test.util.data.collect.DataCollectorManager;

public abstract class MQCollector {
    protected DataCollector msgBodys = null;
    protected DataCollector originMsgs = null;
    protected DataCollector errorMsgs = null;
    protected Map<Object, Object> originMsgIndex = null;
    protected Collection<Object> msgBodysCopy = null;
    protected DataCollector msgRTs = null;

    public MQCollector() {
        this.msgBodys = DataCollectorManager.getInstance().fetchListDataCollector(RandomUtil.getStringByUUID());
        this.originMsgs = DataCollectorManager.getInstance().fetchListDataCollector(RandomUtil.getStringByUUID());
        this.errorMsgs = DataCollectorManager.getInstance().fetchListDataCollector(RandomUtil.getStringByUUID());
        this.originMsgIndex = new ConcurrentHashMap<Object, Object>();
        this.msgRTs = DataCollectorManager.getInstance().fetchListDataCollector(RandomUtil.getStringByUUID());
    }

    public MQCollector(String originMsgCollector, String msgBodyCollector) {
        this.originMsgs = DataCollectorManager.getInstance().fetchDataCollector(originMsgCollector);
        this.msgBodys = DataCollectorManager.getInstance().fetchDataCollector(msgBodyCollector);
    }

    public Collection<Object> getAllMsgBody() {
        return this.msgBodys.getAllData();
    }

    public Collection<Object> getAllOriginMsg() {
        return this.originMsgs.getAllData();
    }

    public Object getFirstMsg() {
        return ((List)this.originMsgs.getAllData()).get(0);
    }

    public Collection<Object> getAllUndupMsgBody() {
        return this.msgBodys.getAllDataWithoutDuplicate();
    }

    public Collection<Object> getAllUndupOriginMsg() {
        return this.originMsgs.getAllData();
    }

    public Collection<Object> getSendErrorMsg() {
        return this.errorMsgs.getAllData();
    }

    public Collection<Object> getMsgRTs() {
        return this.msgRTs.getAllData();
    }

    public Map<Object, Object> getOriginMsgIndex() {
        return this.originMsgIndex;
    }

    public Collection<Object> getMsgBodysCopy() {
        this.msgBodysCopy = new ArrayList<Object>();
        this.msgBodysCopy.addAll(this.msgBodys.getAllData());
        return this.msgBodysCopy;
    }

    public void clearMsg() {
        if (this.msgBodys != null) {
            this.msgBodys.resetData();
        }
        if (this.originMsgs != null) {
            this.originMsgs.resetData();
        }
        if (this.originMsgs != null) {
            this.errorMsgs.resetData();
        }
        if (this.originMsgIndex != null) {
            this.originMsgIndex.clear();
        }
        if (this.msgRTs != null) {
            this.msgRTs.resetData();
        }
    }

    public void lockCollectors() {
        this.msgBodys.lockIncrement();
        this.originMsgs.lockIncrement();
        this.errorMsgs.lockIncrement();
        this.msgRTs.lockIncrement();
    }
}

