/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.util.apache.IntHashMap;

public enum LoggingInfo {
    NOT_LOGGED(0, "NOT_LOGGED", "message is not logged"),
    LOGGED(1, "LOGGED", "message is logged"),
    ALL(11, "ALL", "ALL log level"),
    TRACE(12, "TRACE", "TRACE log level"),
    DEBUG(13, "DEBUG", "DEBUG log level"),
    INFO(14, "INFO", "INFO log level"),
    WARN(15, "WARN", "WARN log level"),
    ERROR(16, "ERROR", "ERROR log level"),
    FATAL(17, "FATAL", "FATAL log level"),
    OFF(18, "OFF", "OFF log level"),
    FINEST_JAVA(31, "FINEST", "SEVERE log level"),
    FINER_JAVA(32, "FINAL", "SEVERE log level"),
    FINE_JAVA(33, "FINE", "SEVERE log level"),
    CONFIG_JAVA(34, "CONFIG", "SEVERE log level"),
    INFO_JAVA(35, "INFO", "SEVERE log level"),
    WARNING_JAVA(36, "WARNING", "SEVERE log level"),
    SEVERE_JAVA(37, "SEVERE", "SEVERE log level");

    private final byte code;
    private final String name;
    private final String desc;
    private static final IntHashMap<LoggingInfo> LOGGING_INFO_MAP;

    private LoggingInfo(byte code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public byte getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    private static IntHashMap<LoggingInfo> toLoggingInfoByCodeMap() {
        IntHashMap<LoggingInfo> loggingInfoMap = new IntHashMap<LoggingInfo>();
        for (LoggingInfo loggingInfo : LoggingInfo.values()) {
            loggingInfoMap.put(loggingInfo.getCode(), loggingInfo);
        }
        return loggingInfoMap;
    }

    public static LoggingInfo searchByCode(byte code) {
        return LOGGING_INFO_MAP.get(code);
    }

    static {
        LOGGING_INFO_MAP = LoggingInfo.toLoggingInfoByCodeMap();
    }
}

