/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.pravega.config;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.common.config.ConfigFiled;

@Config(prefix="eventMesh.server.pravega", path="classPath://pravega-storage.properties")
public class PravegaStorageConfig {
    @ConfigFiled(field="controller.uri")
    private URI controllerURI = URI.create("tcp://127.0.0.1:9090");
    @ConfigFiled(field="scope")
    private String scope = "eventmesh-pravega";
    @ConfigFiled(field="clientPool.size")
    private int clientPoolSize = 8;
    @ConfigFiled(field="queue.size")
    private int queueSize = 512;
    @ConfigFiled(field="authEnabled", reload=true)
    private boolean authEnabled = false;
    @ConfigFiled(field="username")
    private String username = "";
    @ConfigFiled(field="password")
    private String password = "";
    @ConfigFiled(field="tlsEnabled")
    private boolean tlsEnable = false;
    @ConfigFiled(field="truststore")
    private String truststore = "";

    public void reload() {
        if (!this.authEnabled && StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password)) {
            this.authEnabled = true;
        }
    }

    public URI getControllerURI() {
        return this.controllerURI;
    }

    public String getScope() {
        return this.scope;
    }

    public int getClientPoolSize() {
        return this.clientPoolSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isTlsEnable() {
        return this.tlsEnable;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setControllerURI(URI controllerURI) {
        this.controllerURI = controllerURI;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setClientPoolSize(int clientPoolSize) {
        this.clientPoolSize = clientPoolSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTlsEnable(boolean tlsEnable) {
        this.tlsEnable = tlsEnable;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }
}

