/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.tracker;

import java.util.List;
import org.apache.aries.util.tracker.BundleTrackerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.framework.CompositeBundle;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public abstract class AbstractBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    protected void customizedProcessBundle(BundleTrackerCustomizer btc, Bundle b, BundleEvent event, int stateMask) {
        if (b instanceof CompositeBundle) {
            String bundleScope = b.getSymbolicName() + "_" + b.getVersion().toString();
            List<BundleTracker> btList = BundleTrackerFactory.getBundleTrackerList(bundleScope);
            if (event == null) {
                if (b.getState() == 32) {
                    this.openTracker(btc, b, bundleScope, stateMask);
                }
            } else if (event.getType() == 256) {
                if (btList != null) {
                    BundleTrackerFactory.unregisterAndCloseBundleTracker(bundleScope);
                }
            } else if (event.getType() == 128) {
                this.openTracker(btc, b, bundleScope, stateMask);
            }
        }
    }

    private void openTracker(BundleTrackerCustomizer btc, Bundle b, String bundleScope, int stateMask) {
        CompositeBundle cb = (CompositeBundle)b;
        BundleContext compositeBundleContext = cb.getCompositeFramework().getBundleContext();
        BundleTracker bt = new BundleTracker(compositeBundleContext, stateMask, btc);
        bt.open();
        BundleTrackerFactory.registerBundleTracker(bundleScope, bt);
    }
}

