/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.base;

import java.util.Collection;
import java.util.Iterator;
import org.apache.felix.atomos.AtomosContent;
import org.apache.felix.atomos.impl.base.AtomosBase;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

public class AtomosFrameworkHooks
implements ResolverHookFactory,
CollisionHook {
    final AtomosBase atomos;

    AtomosFrameworkHooks(AtomosBase atomos) {
        this.atomos = atomos;
    }

    public ResolverHook begin(Collection<BundleRevision> triggers) {
        return new AtomosResolverHook();
    }

    public void filterCollisions(int operationType, Bundle target, Collection<Bundle> collisionCandidates) {
        AtomosContent currentlyManaging = this.atomos.currentlyManagingConnected();
        if (currentlyManaging != null) {
            Iterator<Bundle> iCands = collisionCandidates.iterator();
            while (iCands.hasNext()) {
                Bundle b = iCands.next();
                AtomosContent candidate = this.atomos.getConnectedContent(b.getLocation());
                if (candidate == null || this.atomos.isInLayerHierarchy(currentlyManaging.getAtomosLayer(), candidate.getAtomosLayer())) continue;
                iCands.remove();
            }
        }
    }

    public class AtomosResolverHook
    implements ResolverHook {
        public void filterResolvable(Collection<BundleRevision> candidates) {
        }

        public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
            AtomosBase.AtomosLayerBase.AtomosContentBase content = AtomosFrameworkHooks.this.atomos.getByConnectLocation(singleton.getRevision().getBundle().getLocation(), true);
            AtomosFrameworkHooks.this.atomos.filterNotVisible(content, collisionCandidates);
        }

        public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
            AtomosBase.AtomosLayerBase.AtomosContentBase atomosBundle = AtomosFrameworkHooks.this.atomos.getByConnectLocation(requirement.getRevision().getBundle().getLocation(), true);
            switch (requirement.getNamespace()) {
                case "osgi.wiring.package": 
                case "osgi.wiring.bundle": {
                    AtomosFrameworkHooks.this.atomos.filterBasedOnReadEdges(atomosBundle, candidates);
                    return;
                }
            }
            AtomosFrameworkHooks.this.atomos.filterNotVisible(atomosBundle, candidates);
        }

        public void end() {
        }
    }
}

