/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import java.util.List;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.test.scenarios.annotations.service.CheckService;
import org.apache.felix.ipojo.test.scenarios.annotations.service.FooService;

public class ServiceProdiving
extends OSGiTestCase {
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
    }

    public void testProvidesSimple() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.ProvidesSimple");
        Element[] provs = meta.getElements("provides");
        ServiceProdiving.assertNotNull((String)"Provides exists ", (Object)provs);
    }

    public void testProvidesDouble() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.ProvidesDouble");
        Element[] provs = meta.getElements("provides");
        ServiceProdiving.assertNotNull((String)"Provides exists ", (Object)provs);
    }

    public void testProvidesTriple() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.ProvidesTriple");
        Element[] provs = meta.getElements("provides");
        ServiceProdiving.assertNotNull((String)"Provides exists ", (Object)provs);
        Element prov = provs[0];
        String itfs = prov.getAttribute("specifications");
        List list = ParseUtils.parseArraysAsList((String)itfs);
        ServiceProdiving.assertTrue((String)"Provides CS ", (boolean)list.contains(CheckService.class.getName()));
    }

    public void testProvidesQuatro() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.ProvidesQuatro");
        Element[] provs = meta.getElements("provides");
        ServiceProdiving.assertNotNull((String)"Provides exists ", (Object)provs);
        Element prov = provs[0];
        String itfs = prov.getAttribute("specifications");
        List list = ParseUtils.parseArraysAsList((String)itfs);
        ServiceProdiving.assertTrue((String)"Provides CS ", (boolean)list.contains(CheckService.class.getName()));
        ServiceProdiving.assertTrue((String)"Provides Foo ", (boolean)list.contains(FooService.class.getName()));
    }

    public void testProperties() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.ProvidesProperties");
        Element[] provs = meta.getElements("provides");
        ServiceProdiving.assertNotNull((String)"Provides exists ", (Object)provs);
        Element prov = provs[0];
        Element[] props = prov.getElements("property");
        ServiceProdiving.assertEquals((String)"Number of properties", (int)props.length, (int)5);
        Element foo = this.getPropertyByName(props, "foo");
        ServiceProdiving.assertEquals((String)"Check foo field", (String)"m_foo", (String)foo.getAttribute("field"));
        ServiceProdiving.assertEquals((String)"Check foo name", (String)"foo", (String)foo.getAttribute("name"));
        Element bar = this.getPropertyByName(props, "bar");
        ServiceProdiving.assertEquals((String)"Check bar field", (String)"bar", (String)bar.getAttribute("field"));
        ServiceProdiving.assertEquals((String)"Check bar value", (String)"4", (String)bar.getAttribute("value"));
        ServiceProdiving.assertEquals((String)"Check mandatory value", (String)"true", (String)bar.getAttribute("mandatory"));
        Element boo = this.getPropertyByName(props, "boo");
        ServiceProdiving.assertEquals((String)"Check boo field", (String)"boo", (String)boo.getAttribute("field"));
        Element baa = this.getPropertyByName(props, "baa");
        ServiceProdiving.assertEquals((String)"Check baa field", (String)"m_baa", (String)baa.getAttribute("field"));
        ServiceProdiving.assertEquals((String)"Check baa name", (String)"baa", (String)baa.getAttribute("name"));
        Element baz = this.getPropertyByName(props, "baz");
        ServiceProdiving.assertEquals((String)"Check baz field", (String)"m_baz", (String)baz.getAttribute("field"));
        ServiceProdiving.assertEquals((String)"Check baz name", (String)"baz", (String)baz.getAttribute("name"));
    }

    public void testStaticProperties() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.ProvidesStaticProperties");
        Element[] provs = meta.getElements("provides");
        ServiceProdiving.assertNotNull((String)"Provides exists ", (Object)provs);
        Element prov = provs[0];
        Element[] props = prov.getElements("property");
        ServiceProdiving.assertEquals((String)"Number of properties", (int)props.length, (int)9);
        Element foo = this.getPropertyByName(props, "prop1");
        ServiceProdiving.assertNull((Object)foo.getAttribute("field"));
        ServiceProdiving.assertEquals((String)"prop1", (String)foo.getAttribute("value"));
        Element prop2 = this.getPropertyByName(props, "prop2");
        ServiceProdiving.assertNull((Object)prop2.getAttribute("field"));
        ServiceProdiving.assertNull((Object)prop2.getAttribute("value"));
        Element prop = this.getPropertyByName(props, "props");
        ServiceProdiving.assertNull((Object)prop.getAttribute("field"));
        ServiceProdiving.assertEquals((String)"{prop1, prop2}", (String)prop.getAttribute("value"));
        Element mandatory = this.getPropertyByName(props, "mandatory1");
        ServiceProdiving.assertNull((Object)mandatory.getAttribute("field"));
        ServiceProdiving.assertNull((Object)mandatory.getAttribute("value"));
        ServiceProdiving.assertEquals((String)"true", (String)mandatory.getAttribute("mandatory"));
        Element bar = this.getPropertyByName(props, "bar");
        ServiceProdiving.assertEquals((String)"Check bar field", (String)"bar", (String)bar.getAttribute("field"));
        ServiceProdiving.assertEquals((String)"Check bar value", (String)"4", (String)bar.getAttribute("value"));
        ServiceProdiving.assertEquals((String)"Check mandatory value", (String)"true", (String)bar.getAttribute("mandatory"));
        Element boo = this.getPropertyByName(props, "boo");
        ServiceProdiving.assertEquals((String)"Check boo field", (String)"boo", (String)boo.getAttribute("field"));
        Element baa = this.getPropertyByName(props, "baa");
        ServiceProdiving.assertEquals((String)"Check baa field", (String)"m_baa", (String)baa.getAttribute("field"));
        ServiceProdiving.assertEquals((String)"Check baa name", (String)"baa", (String)baa.getAttribute("name"));
        Element baz = this.getPropertyByName(props, "baz");
        ServiceProdiving.assertEquals((String)"Check baz field", (String)"m_baz", (String)baz.getAttribute("field"));
        ServiceProdiving.assertEquals((String)"Check baz name", (String)"baz", (String)baz.getAttribute("name"));
    }

    public void testServiceController() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.PSServiceController");
        Element[] provs = meta.getElements("provides");
        ServiceProdiving.assertNotNull((String)"Provides exists ", (Object)provs);
        System.out.println(provs[0].toString());
        ServiceProdiving.assertNotNull((Object)provs[0].getElements("controller"));
        ServiceProdiving.assertEquals((int)1, (int)provs[0].getElements("controller").length);
        ServiceProdiving.assertEquals((String)"false", (String)provs[0].getElements("controller")[0].getAttribute("value"));
    }

    public void testServiceControllerWithSpecification() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.PSServiceControllerSpec");
        Element[] provs = meta.getElements("provides");
        ServiceProdiving.assertNotNull((String)"Provides exists ", (Object)provs);
        System.out.println(provs[0].toString());
        ServiceProdiving.assertNotNull((Object)provs[0].getElements("controller"));
        ServiceProdiving.assertEquals((int)2, (int)provs[0].getElements("controller").length);
        ServiceProdiving.assertEquals((String)"false", (String)provs[0].getElements("controller")[0].getAttribute("value"));
        ServiceProdiving.assertEquals((String)FooService.class.getName(), (String)provs[0].getElements("controller")[0].getAttribute("specification"));
    }

    private Element getPropertyByName(Element[] props, String name) {
        int i = 0;
        while (i < props.length) {
            String na = props[i].getAttribute("name");
            String field = props[i].getAttribute("field");
            if (na != null && na.equalsIgnoreCase(name)) {
                return props[i];
            }
            if (field != null && field.equalsIgnoreCase(name)) {
                return props[i];
            }
            ++i;
        }
        ServiceProdiving.fail((String)("Property  " + name + " not found"));
        return null;
    }
}

