/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.upnp.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.plugins.upnp.internal.ControlServlet;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class WebConsolePlugin
extends SimpleWebConsolePlugin {
    private static final String LABEL = "upnp";
    private static final String TITLE = "%pluginTitle";
    private static final String CATEGORY = "OSGi";
    private static final String[] CSS = new String[]{"/upnp/res/upnp.css", "/upnp/res/jquery-treeview-1.4/jquery.treeview.css"};
    private final ServiceTracker tracker;
    ControlServlet controller;
    private final String TEMPLATE;

    public WebConsolePlugin(ServiceTracker tracker) {
        super(LABEL, TITLE, CSS);
        this.tracker = tracker;
        this.TEMPLATE = this.readTemplateFile("/res/upnp.html");
    }

    public String getCategory() {
        return CATEGORY;
    }

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
        this.controller = new ControlServlet(bundleContext, this.tracker, this);
    }

    public void deactivate() {
        if (this.controller != null) {
            this.controller.close();
            this.controller = null;
        }
        super.deactivate();
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.getWriter().print(this.TEMPLATE);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("action") != null) {
            this.controller.doPost(request, response);
        } else {
            super.doPost(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("icon") != null) {
            this.controller.doGet(request, response);
        } else {
            super.doGet(request, response);
        }
    }
}

