////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

/**
 *  The vertical distance in pixels from the top edge of the content area to 
 *  the control's baseline position. 
 *  If this style is set, the baseline of the component is
 *  anchored to the top edge of its content area; when its container
 *  is resized, the two edges maintain their separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="baseline", type="String", inherit="no")]

/**
 *  The vertical distance, in pixels, from the bottom edge of the component 
 *  to the bottom edge of its parent container's content area.
 *  If this style is set, the lower edge of the component is
 *  anchored to the bottom edge of its content area; when its container
 *  is resized, the two edges maintain their separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="bottom", type="String", inherit="no")]

/**
 *  The horizontal distance in pixels from the center of the component's
 *  content area to the center of the component.
 *  If this style is set, the center of the component is
 *  anchored to the center of its content area; when its container
 *  is resized, the two centers maintain their horizontal separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="horizontalCenter", type="String", inherit="no")]

/**
 *  The horizontal distance, in pixels, from the left edge of the component 
 *  to the left edge of its parent container's content area.
 *  If this style is set, the left edge of the component is
 *  anchored to the left edge of its content area; when its container
 *  is resized, the two edges maintain their separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="left", type="String", inherit="no")]

/**
 *  The horizontal distance, in pixels, from the right edge of the component 
 *  to the right edge of its parent container's content area.
 *  If this style is set, the right edge of the component is
 *  anchored to the right edge of its content area; when its container
 *  is resized, the two edges maintain their separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="right", type="String", inherit="no")]

/**
 *  The vertical distance, in pixels, from the top edge of the component 
 *  to the top edge of its parent container's content area.
 *  If this style is set, the top edge of the component is
 *  anchored to the top edge of its content area; when its container
 *  is resized, the two edges maintain their separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="top", type="String", inherit="no")]

/**
 *  The vertical distance in pixels from the center of the component's
 *  content area to the center of the component.
 *  If this style is set, the center of the component is 
 *  anchored to the center of its content area; when its container
 *  is resized, the two centers maintain their vertical separation.
 * 
 *  <p>This style only has an effect when used on a component in a Canvas container, 
 *  or when used on a component in a Panel or Application container that has the 
 *  <code>layout</code> property set to <code>absolute</code>.</p> 
 * 
 *  <p>The default value is <code>undefined</code>, which means it is not set.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="verticalCenter", type="String", inherit="no")]
