/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import flex.messaging.services.messaging.adapters.JMSSettings;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class JMSProxy {
    protected Connection connection;
    protected ConnectionCredentials connectionCredentials;
    protected ConnectionFactory connectionFactory;
    protected Session session;
    protected Destination destination;
    protected Context jndiContext;
    protected int acknowledgeMode = 1;
    protected String connectionFactoryName;
    protected String destinationJndiName;
    protected Hashtable initialContextEnvironment;

    public void initialize(JMSSettings settings) {
        String ackString = settings.getAcknowledgeMode();
        if (ackString.equals("auto_acknowledge")) {
            this.acknowledgeMode = 1;
        } else if (ackString.equals("client_acknowledge")) {
            this.acknowledgeMode = 2;
        } else if (ackString.equals("dups_ok_acknowledge")) {
            this.acknowledgeMode = 3;
        }
        this.connectionFactoryName = settings.getConnectionFactory();
        String username = settings.getConnectionUsername();
        String password = settings.getConnectionPassword();
        if (username != null || password != null) {
            this.connectionCredentials = new ConnectionCredentials(username, password);
        }
        this.destinationJndiName = settings.getDestinationJNDIName();
        this.initialContextEnvironment = settings.getInitialContextEnvironment();
    }

    protected void validate() {
        if (this.connectionFactoryName == null) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10804);
            throw ce;
        }
        if (this.destinationJndiName == null) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10807);
            throw ce;
        }
    }

    public void start() throws NamingException, JMSException {
        this.validate();
        this.initializeJndiContext();
        this.initializeConnectionFactory();
        this.initializeDestination();
    }

    public void stop() {
        block11: {
            block10: {
                block9: {
                    try {
                        if (this.session != null) {
                            this.session.close();
                        }
                    }
                    catch (JMSException e) {
                        if (!Log.isWarn()) break block9;
                        Log.getLogger((String)"Service.Message.JMS").warn("JMS proxy for JMS destination '" + this.destinationJndiName + "' received an error while closing its underlying Session: " + e.getMessage());
                    }
                }
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (JMSException e) {
                    if (!Log.isWarn()) break block10;
                    Log.getLogger((String)"Service.Message.JMS").warn("JMS proxy for JMS destination '" + this.destinationJndiName + "' received an error while closing its underlying Connection: " + e.getMessage());
                }
            }
            try {
                if (this.jndiContext != null) {
                    this.jndiContext.close();
                }
            }
            catch (NamingException e) {
                if (!Log.isWarn()) break block11;
                Log.getLogger((String)"Service.Message.JMS").warn("JMS proxy for JMS destination '" + this.destinationJndiName + "' received an error while closing its underlying JNDI context: " + e.getMessage());
            }
        }
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        if (acknowledgeMode == 1 || acknowledgeMode == 2 || acknowledgeMode == 3) {
            this.acknowledgeMode = acknowledgeMode;
        }
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public ConnectionCredentials getConnectionCredentials() {
        return this.connectionCredentials;
    }

    public void setConnectionCredentials(ConnectionCredentials connectionCredentials) {
        this.connectionCredentials = connectionCredentials;
    }

    public String getDestinationJndiName() {
        return this.destinationJndiName;
    }

    public void setDestinationJndiName(String destinationJndiName) {
        this.destinationJndiName = destinationJndiName;
    }

    public Hashtable getInitialContextEnvironment() {
        return this.initialContextEnvironment;
    }

    public void setInitialContextEnvironment(Hashtable env) {
        this.initialContextEnvironment = env;
    }

    protected ConnectionFactory initializeConnectionFactory() throws NamingException {
        if (this.connectionFactory == null) {
            this.connectionFactory = (ConnectionFactory)this.jndiContext.lookup(this.connectionFactoryName);
        }
        return this.connectionFactory;
    }

    protected Destination initializeDestination() throws NamingException {
        if (this.destination == null) {
            this.destination = (Destination)this.jndiContext.lookup(this.destinationJndiName);
        }
        return this.destination;
    }

    protected Context initializeJndiContext() throws NamingException {
        if (this.jndiContext != null) {
            this.stop();
        }
        this.jndiContext = this.initialContextEnvironment != null ? new InitialContext(this.initialContextEnvironment) : new InitialContext();
        return this.jndiContext;
    }

    public static class ConnectionCredentials {
        private String username;
        private String password;

        public ConnectionCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

