/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Action;
import flash.swf.actions.Label;
import flash.swf.actions.Push;
import flash.swf.actions.StoreRegister;
import flash.swf.actions.StrictMode;
import flash.swf.actions.WaitForFrame;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.ActionList;
import java.util.ArrayList;
import java.util.List;

public final class ActionFactory {
    public static final Object UNDEFINED;
    public static final Object STACKTOP;
    private static final Action[] actionFlyweights;
    private static final Push[] pushCpoolFlyweights;
    private static final Push[] pushRegisterFlyweights;
    private static final StoreRegister[] storeRegisterFlyweights;
    private static final Push pushTrueFlyweight;
    private static final Push pushFalseFlyweight;
    private static final Push pushUndefinedFlyweight;
    private static final Push pushNullFlyweight;
    private static final Push pushFloat0Flyweight;
    private static final Push pushInteger0Flyweight;
    private static final Push pushDouble0Flyweight;
    private static final Action callFlyweight;
    private static final StrictMode strictTrueFlyweight;
    private static final StrictMode strictFalseFlyweight;
    private final int startOffset;
    private final int startCount;
    private final Action[] actions;
    private final Label[] labels;
    private final LineRecord[] lines;
    private final RegisterRecord[] registers;
    private final int[] actionOffsets;
    private int count;
    private List<SkipEntry> skipRecords;

    public static Action createAction(int n) {
        return actionFlyweights[n];
    }

    public static Push createPushCpool(int n) {
        return n < pushCpoolFlyweights.length ? pushCpoolFlyweights[n] : new Push(new Short((short)n));
    }

    public static Push createPush(String string) {
        return new Push(string);
    }

    public static Push createPush(float f) {
        return f == 0.0f ? pushFloat0Flyweight : new Push(new Float(f));
    }

    public static Push createPushNull() {
        return pushNullFlyweight;
    }

    public static Push createPushUndefined() {
        return pushUndefinedFlyweight;
    }

    public static Push createPushRegister(int n) {
        return pushRegisterFlyweights[n];
    }

    public static Push createPush(boolean bl) {
        return bl ? pushTrueFlyweight : pushFalseFlyweight;
    }

    public static Push createPush(double d) {
        return d == 0.0 ? pushDouble0Flyweight : new Push(new Double(d));
    }

    public static Push createPush(int n) {
        return n == 0 ? pushInteger0Flyweight : new Push(new Integer(n));
    }

    public static StoreRegister createStoreRegister(int n) {
        return storeRegisterFlyweights[n];
    }

    public static Action createCall() {
        return callFlyweight;
    }

    public static StrictMode createStrictMode(boolean bl) {
        return bl ? strictTrueFlyweight : strictFalseFlyweight;
    }

    public ActionFactory(int n, int n2, int n3) {
        this.startOffset = n2;
        this.startCount = n3;
        this.labels = new Label[n + 1];
        this.lines = new LineRecord[n];
        this.registers = new RegisterRecord[n];
        this.actions = new Action[n];
        this.actionOffsets = new int[n + 1];
        this.skipRecords = new ArrayList<SkipEntry>();
    }

    public void setLine(int n, LineRecord lineRecord) {
        int n2 = n - this.startOffset;
        if (this.lines[n2] == null) {
            ++this.count;
        }
        this.lines[n2] = lineRecord;
    }

    public void setRegister(int n, RegisterRecord registerRecord) {
        int n2 = n - this.startOffset;
        if (this.registers[n2] == null) {
            ++this.count;
        }
        this.registers[n2] = registerRecord;
    }

    public void setAction(int n, Action action) {
        int n2 = n - this.startOffset;
        if (this.actions[n2] == null) {
            ++this.count;
        }
        this.actions[n2] = action;
    }

    public Label getLabel(int n) {
        int n2 = n - this.startOffset;
        Label label = null;
        if (n2 >= 0 && n2 < this.labels.length && (label = this.labels[n2]) == null) {
            this.labels[n2] = label = new Label();
            ++this.count;
        }
        return label;
    }

    public void setActionOffset(int n, int n2) {
        this.actionOffsets[n - this.startCount] = n2;
    }

    public ActionList createActionList(boolean bl) {
        this.processSkipEntries();
        ActionList actionList = new ActionList(bl);
        actionList.grow(this.count);
        int n = this.actions.length;
        if (bl) {
            Action action;
            for (int i = 0; i < n; ++i) {
                int n2 = this.startOffset + i;
                action = this.actions[i];
                if (action != null) {
                    actionList.insert(n2, action);
                }
                if ((action = this.lines[i]) != null) {
                    actionList.insert(n2, action);
                }
                if ((action = this.registers[i]) != null) {
                    actionList.insert(n2, action);
                }
                if ((action = this.labels[i]) == null) continue;
                actionList.insert(n2, action);
            }
            action = this.labels[n];
            if (action != null) {
                actionList.insert(this.startOffset + n, action);
            }
        } else {
            Action action;
            for (int i = 0; i < n; ++i) {
                action = this.labels[i];
                if (action != null) {
                    actionList.append(action);
                }
                if ((action = this.lines[i]) != null) {
                    actionList.append(action);
                }
                if ((action = this.registers[i]) != null) {
                    actionList.append(action);
                }
                if ((action = this.actions[i]) == null) continue;
                actionList.append(action);
            }
            action = this.labels[n];
            if (action != null) {
                actionList.append(action);
            }
        }
        return actionList;
    }

    private void processSkipEntries() {
        for (SkipEntry skipEntry : this.skipRecords) {
            int n = this.actionOffsets[skipEntry.skipTarget - this.startCount];
            skipEntry.action.skipTarget = this.getLabel(n);
        }
    }

    public void addSkipEntry(WaitForFrame waitForFrame, int n) {
        this.skipRecords.add(new SkipEntry(waitForFrame, n));
    }

    static {
        int n;
        UNDEFINED = new Object(){

            public String toString() {
                return "undefined";
            }
        };
        STACKTOP = new Object(){

            public String toString() {
                return "stack";
            }
        };
        actionFlyweights = new Action[128];
        pushCpoolFlyweights = new Push[256];
        pushRegisterFlyweights = new Push[256];
        storeRegisterFlyweights = new StoreRegister[256];
        pushTrueFlyweight = new Push(Boolean.TRUE);
        pushFalseFlyweight = new Push(Boolean.FALSE);
        pushUndefinedFlyweight = new Push(UNDEFINED);
        pushNullFlyweight = new Push(null);
        pushFloat0Flyweight = new Push(new Float(0.0f));
        pushInteger0Flyweight = new Push(new Integer(0));
        pushDouble0Flyweight = new Push(new Double(0.0));
        callFlyweight = new Action(158);
        strictTrueFlyweight = new StrictMode(true);
        strictFalseFlyweight = new StrictMode(false);
        for (n = 0; n < 128; ++n) {
            ActionFactory.actionFlyweights[n] = new Action(n);
        }
        for (n = 0; n < 256; ++n) {
            ActionFactory.pushRegisterFlyweights[n] = new Push(new Byte((byte)n));
            ActionFactory.pushCpoolFlyweights[n] = new Push(new Short((short)n));
            ActionFactory.storeRegisterFlyweights[n] = new StoreRegister(n);
        }
    }

    private static class SkipEntry {
        WaitForFrame action;
        int skipTarget;

        public SkipEntry(WaitForFrame waitForFrame, int n) {
            this.action = waitForFrame;
            this.skipTarget = n;
        }
    }
}

