/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterTableOperation;
import org.apache.flink.table.utils.EncodingUtils;

public class AlterTableChangeOperation
extends AlterTableOperation {
    private final List<TableChange> tableChanges;
    private final CatalogTable newTable;

    public AlterTableChangeOperation(ObjectIdentifier tableIdentifier, List<TableChange> tableChanges, CatalogTable newTable, boolean ignoreIfNotExists) {
        super(tableIdentifier, ignoreIfNotExists);
        this.tableChanges = Collections.unmodifiableList(tableChanges);
        this.newTable = newTable;
    }

    public List<TableChange> getTableChanges() {
        return this.tableChanges;
    }

    public CatalogTable getNewTable() {
        return this.newTable;
    }

    @Override
    public String asSummaryString() {
        String changes = this.tableChanges.stream().map(this::toString).collect(Collectors.joining(",\n"));
        return String.format("ALTER TABLE %s%s\n%s", this.ignoreIfTableNotExists ? "IF EXISTS " : "", this.tableIdentifier.asSummaryString(), changes);
    }

    private String toString(TableChange tableChange) {
        if (tableChange instanceof TableChange.SetOption) {
            TableChange.SetOption setChange = (TableChange.SetOption)tableChange;
            return String.format("  SET '%s' = '%s'", setChange.getKey(), setChange.getValue());
        }
        if (tableChange instanceof TableChange.ResetOption) {
            TableChange.ResetOption resetChange = (TableChange.ResetOption)tableChange;
            return String.format("  RESET '%s'", resetChange.getKey());
        }
        if (tableChange instanceof TableChange.AddColumn) {
            TableChange.AddColumn addColumn = (TableChange.AddColumn)tableChange;
            return String.format("  ADD %s %s", addColumn.getColumn(), addColumn.getPosition() == null ? "" : addColumn.getPosition());
        }
        if (tableChange instanceof TableChange.AddWatermark) {
            TableChange.AddWatermark addWatermark = (TableChange.AddWatermark)tableChange;
            return String.format("  ADD %s", addWatermark.getWatermark());
        }
        if (tableChange instanceof TableChange.AddUniqueConstraint) {
            TableChange.AddUniqueConstraint addUniqueConstraint = (TableChange.AddUniqueConstraint)tableChange;
            return String.format("  ADD %s", addUniqueConstraint.getConstraint());
        }
        if (tableChange instanceof TableChange.ModifyColumnComment) {
            TableChange.ModifyColumnComment modifyColumnComment = (TableChange.ModifyColumnComment)tableChange;
            return String.format("  MODIFY %s COMMENT '%s'", EncodingUtils.escapeIdentifier(modifyColumnComment.getNewColumn().getName()), modifyColumnComment.getNewComment());
        }
        if (tableChange instanceof TableChange.ModifyPhysicalColumnType) {
            TableChange.ModifyPhysicalColumnType modifyPhysicalColumnType = (TableChange.ModifyPhysicalColumnType)tableChange;
            return String.format("  MODIFY %s %s", EncodingUtils.escapeIdentifier(modifyPhysicalColumnType.getNewColumn().getName()), modifyPhysicalColumnType.getNewType());
        }
        if (tableChange instanceof TableChange.ModifyColumnPosition) {
            TableChange.ModifyColumnPosition modifyColumnPosition = (TableChange.ModifyColumnPosition)tableChange;
            return String.format("  MODIFY %s %s", EncodingUtils.escapeIdentifier(modifyColumnPosition.getNewColumn().getName()), modifyColumnPosition.getNewPosition());
        }
        if (tableChange instanceof TableChange.ModifyColumnName) {
            TableChange.ModifyColumnName modifyColumnName = (TableChange.ModifyColumnName)tableChange;
            return String.format("  MODIFY %s TO %s", EncodingUtils.escapeIdentifier(modifyColumnName.getOldColumnName()), EncodingUtils.escapeIdentifier(modifyColumnName.getNewColumnName()));
        }
        if (tableChange instanceof TableChange.ModifyColumn) {
            TableChange.ModifyColumn modifyColumn = (TableChange.ModifyColumn)tableChange;
            return String.format("  MODIFY %s %s", modifyColumn.getNewColumn(), modifyColumn.getNewPosition() == null ? "" : modifyColumn.getNewPosition());
        }
        if (tableChange instanceof TableChange.ModifyWatermark) {
            TableChange.ModifyWatermark modifyWatermark = (TableChange.ModifyWatermark)tableChange;
            return String.format("  MODIFY %s", modifyWatermark.getNewWatermark());
        }
        if (tableChange instanceof TableChange.ModifyUniqueConstraint) {
            TableChange.ModifyUniqueConstraint modifyUniqueConstraint = (TableChange.ModifyUniqueConstraint)tableChange;
            return String.format("  MODIFY %s", modifyUniqueConstraint.getNewConstraint());
        }
        if (tableChange instanceof TableChange.DropColumn) {
            TableChange.DropColumn dropColumn = (TableChange.DropColumn)tableChange;
            return String.format("  DROP %s", EncodingUtils.escapeIdentifier(dropColumn.getColumnName()));
        }
        if (tableChange instanceof TableChange.DropConstraint) {
            TableChange.DropConstraint dropConstraint = (TableChange.DropConstraint)tableChange;
            return String.format("  DROP CONSTRAINT %s", dropConstraint.getConstraintName());
        }
        if (tableChange instanceof TableChange.DropWatermark) {
            return "  DROP WATERMARK";
        }
        throw new UnsupportedOperationException(String.format("Unknown table change: %s.", tableChange));
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ctx.getCatalogManager().alterTable(this.getNewTable(), this.getTableChanges(), this.getTableIdentifier(), this.ignoreIfTableNotExists());
        return TableResultImpl.TABLE_RESULT_OK;
    }
}

