/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.connector.jdbc.databases.trino.table;

import org.apache.flink.connector.jdbc.databases.trino.TrinoTestBase;
import org.apache.flink.connector.jdbc.databases.trino.dialect.TrinoDialect;
import org.apache.flink.connector.jdbc.table.JdbcDynamicTableSourceITCase;
import org.apache.flink.connector.jdbc.testutils.tables.TableRow;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.types.Row;

import org.junit.jupiter.api.Disabled;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.List;

import static org.apache.flink.connector.jdbc.testutils.tables.TableBuilder.dbType;
import static org.apache.flink.connector.jdbc.testutils.tables.TableBuilder.field;
import static org.apache.flink.connector.jdbc.testutils.tables.TableBuilder.tableRow;

/** The Table Source ITCase for {@link TrinoDialect}. */
@Disabled("Not working on jenkins as container not start.")
class TrinoDynamicTableSourceITCase extends JdbcDynamicTableSourceITCase implements TrinoTestBase {

    @Override
    protected TableRow createInputTable() {
        return tableRow(
                "jdbDynamicTableSource",
                field("id", dbType("INTEGER"), DataTypes.BIGINT()),
                field("decimal_col", DataTypes.DECIMAL(10, 4)),
                field("timestamp6_col", DataTypes.TIMESTAMP(6)),
                // other fields
                field("double_col", DataTypes.DOUBLE()),
                field("char_col", dbType("CHAR"), DataTypes.CHAR(1)),
                field("varchar_col", dbType("VARCHAR(30)"), DataTypes.VARCHAR(30)),
                field("date_col", dbType("DATE"), DataTypes.DATE()));
    }

    @Override
    protected List<Row> getTestData() {
        return Arrays.asList(
                Row.of(
                        1L,
                        BigDecimal.valueOf(100.1234),
                        LocalDateTime.parse("2020-01-01T15:35:00.123"),
                        2.12345678790D,
                        "a",
                        "abcdef",
                        LocalDate.parse("1997-01-01")),
                Row.of(
                        2L,
                        BigDecimal.valueOf(101.1234),
                        LocalDateTime.parse("2020-01-01T15:36:01.123"),
                        2.12345678790D,
                        "a",
                        "abcdef",
                        LocalDate.parse("1997-01-02")));
    }

    @Override
    protected TemporalUnit timestampPrecision() {
        return ChronoUnit.MILLIS;
    }
}
