/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.feedback;

import java.util.Objects;
import java.util.OptionalLong;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.common.SerializableFunction;
import org.apache.flink.statefun.flink.core.feedback.FeedbackKey;
import org.apache.flink.statefun.flink.core.feedback.FeedbackUnionOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;

public final class FeedbackUnionOperatorFactory<E>
implements OneInputStreamOperatorFactory<E, E>,
YieldingOperatorFactory<E> {
    private static final long serialVersionUID = 1L;
    private final StatefulFunctionsConfig configuration;
    private final FeedbackKey<E> feedbackKey;
    private final SerializableFunction<E, OptionalLong> isBarrierMessage;
    private final SerializableFunction<E, ?> keySelector;
    private transient MailboxExecutor mailboxExecutor;

    public FeedbackUnionOperatorFactory(StatefulFunctionsConfig configuration, FeedbackKey<E> feedbackKey, SerializableFunction<E, OptionalLong> isBarrierMessage, SerializableFunction<E, ?> keySelector) {
        this.feedbackKey = Objects.requireNonNull(feedbackKey);
        this.isBarrierMessage = Objects.requireNonNull(isBarrierMessage);
        this.keySelector = Objects.requireNonNull(keySelector);
        this.configuration = Objects.requireNonNull(configuration);
    }

    public <T extends StreamOperator<E>> T createStreamOperator(StreamOperatorParameters<E> streamOperatorParameters) {
        TypeSerializer serializer = streamOperatorParameters.getStreamConfig().getTypeSerializerIn(0, streamOperatorParameters.getContainingTask().getUserCodeClassLoader());
        FeedbackUnionOperator<E> op = new FeedbackUnionOperator<E>(this.feedbackKey, this.isBarrierMessage, this.keySelector, this.configuration.getFeedbackBufferSize().getBytes(), serializer, this.mailboxExecutor, streamOperatorParameters.getProcessingTimeService());
        op.setup(streamOperatorParameters.getContainingTask(), streamOperatorParameters.getStreamConfig(), streamOperatorParameters.getOutput());
        return (T)op;
    }

    public void setMailboxExecutor(MailboxExecutor mailboxExecutor) {
        this.mailboxExecutor = Objects.requireNonNull(mailboxExecutor, "Mailbox executor can't be NULL");
    }

    public void setChainingStrategy(ChainingStrategy chainingStrategy) {
    }

    public ChainingStrategy getChainingStrategy() {
        return ChainingStrategy.ALWAYS;
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return FeedbackUnionOperator.class;
    }
}

