/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.logger;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.SpillingBuffer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.statefun.flink.core.feedback.FeedbackConsumer;
import org.apache.flink.statefun.flink.core.logger.MemorySegmentPool;

final class KeyGroupStream<T> {
    private final TypeSerializer<T> serializer;
    private final SpillingBuffer target;
    private final MemorySegmentPool memoryPool;
    private final DataOutputSerializer output = new DataOutputSerializer(256);
    private long totalSize;
    private int elementCount;

    KeyGroupStream(TypeSerializer<T> serializer, IOManager ioManager, MemorySegmentPool memorySegmentPool) {
        this.serializer = Objects.requireNonNull(serializer);
        this.memoryPool = Objects.requireNonNull(memorySegmentPool);
        memorySegmentPool.ensureAtLeastOneSegmentPresent();
        this.target = new SpillingBuffer(ioManager, (MemorySegmentSource)memorySegmentPool, memorySegmentPool.getSegmentSize());
    }

    static <T> void readFrom(DataInputView source, TypeSerializer<T> serializer, FeedbackConsumer<T> consumer) throws Exception {
        int elementCount = source.readInt();
        for (int i = 0; i < elementCount; ++i) {
            Object envelope = serializer.deserialize(source);
            consumer.processFeedback(envelope);
        }
    }

    private static void copy(@Nonnull DataInputView source, @Nonnull DataOutputView target, long size) throws IOException {
        while (size > 0L) {
            int len = (int)Math.min(4096L, size);
            target.write(source, len);
            size -= (long)len;
        }
    }

    void append(T envelope) {
        ++this.elementCount;
        try {
            this.output.clear();
            this.serializer.serialize(envelope, (DataOutputView)this.output);
            this.totalSize += (long)this.output.length();
            this.target.write(this.output.getSharedBuffer(), 0, this.output.length());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void writeTo(DataOutputView target) throws IOException {
        target.writeInt(this.elementCount);
        KeyGroupStream.copy(this.target.flip(), target, this.totalSize);
        for (MemorySegment segment : this.target.close()) {
            this.memoryPool.release(segment);
        }
    }

    public static void writeEmptyTo(DataOutputView target) throws IOException {
        target.writeInt(0);
    }
}

