/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.message;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.statefun.flink.common.protobuf.ProtobufReflectionUtil;
import org.apache.flink.statefun.flink.core.generated.Payload;
import org.apache.flink.statefun.flink.core.message.MessagePayloadSerializer;

@NotThreadSafe
public class MessagePayloadSerializerPb
implements MessagePayloadSerializer {
    private final ObjectOpenHashMap<String, ObjectOpenHashMap<ClassLoader, Parser<? extends Message>>> PARSER_CACHE = new ObjectOpenHashMap();

    @Override
    public Object deserialize(@Nonnull ClassLoader targetClassLoader, @Nonnull Payload payload) {
        try {
            Parser<? extends Message> parser = this.parserForClassName(targetClassLoader, payload.getClassName());
            return parser.parseFrom(payload.getPayloadBytes());
        }
        catch (InvalidProtocolBufferException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Payload serialize(@Nonnull Object what) {
        Message message = (Message)what;
        String className = what.getClass().getName();
        ByteString body = message.toByteString();
        return Payload.newBuilder().setClassName(className).setPayloadBytes(body).build();
    }

    @Override
    public Object copy(@Nonnull ClassLoader targetClassLoader, @Nonnull Object what) {
        Objects.requireNonNull(targetClassLoader);
        if (!(what instanceof Message)) {
            throw new IllegalStateException();
        }
        Message message = (Message)what;
        ByteString messageBytes = message.toByteString();
        try {
            Parser<? extends Message> parser = this.parserForClassName(targetClassLoader, what.getClass().getName());
            return parser.parseFrom(messageBytes);
        }
        catch (InvalidProtocolBufferException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private Parser<? extends Message> parserForClassName(ClassLoader userCodeClassLoader, String messageClassName) throws ClassNotFoundException {
        Parser<? extends Message> parser;
        ObjectOpenHashMap<ClassLoader, Object> classLoaders = this.PARSER_CACHE.get(messageClassName);
        if (classLoaders == null) {
            classLoaders = new ObjectOpenHashMap();
            this.PARSER_CACHE.put(messageClassName, classLoaders);
        }
        if ((parser = classLoaders.get(userCodeClassLoader)) == null) {
            parser = this.findParser(userCodeClassLoader, messageClassName);
            classLoaders.put(userCodeClassLoader, parser);
        }
        return parser;
    }

    private Parser<? extends Message> findParser(ClassLoader userCodeClassLoader, String messageClassName) throws ClassNotFoundException {
        Class<Message> messageType = Class.forName(messageClassName, true, userCodeClassLoader).asSubclass(Message.class);
        return ProtobufReflectionUtil.protobufParser(messageType);
    }
}

