/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.util.Preconditions;

public class ReflectionUtils {
    public static Field getClassField(Class<?> declaredClass, String fieldName) {
        try {
            Field field = declaredClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get field" + fieldName + " from " + declaredClass, e);
        }
    }

    public static <T> T getFieldValue(Object targetObject, Field field) {
        try {
            return (T)field.get(targetObject);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get field " + field.getName() + " from " + targetObject, e);
        }
    }

    public static <T> T getFieldValue(Object targetObject, Class<?> declaredClass, String fieldName) {
        Field field = ReflectionUtils.getClassField(declaredClass, fieldName);
        return ReflectionUtils.getFieldValue(targetObject, field);
    }

    public static <T> T callMethod(Object targetObject, Class<?> declaredClass, String methodName) {
        return ReflectionUtils.callMethod(targetObject, declaredClass, methodName, Collections.emptyList(), Collections.emptyList());
    }

    public static <T> T callMethod(Object targetObject, Class<?> declaredClass, String methodName, List<Class<?>> parameterClass, List<Object> parameters) {
        Method method;
        try {
            method = declaredClass.getDeclaredMethod(methodName, parameterClass.toArray(new Class[0]));
            method.setAccessible(true);
        }
        catch (NoSuchMethodException e1) {
            try {
                method = declaredClass.getMethod(methodName, parameterClass.toArray(new Class[0]));
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException("Failed to get method" + methodName + " from " + targetObject, e2);
            }
        }
        try {
            return (T)method.invoke(targetObject, parameters.toArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke method" + methodName + " from " + targetObject, e);
        }
    }

    public static <T> T callMethod(Object targetObject, Class<?> declaredClass, String methodName, Object[] parameters) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : declaredClass.getMethods()) {
            if (!methodName.equals(m.getName())) continue;
            methods.add(m);
        }
        Preconditions.checkState((methods.size() == 1 ? 1 : 0) != 0, (String)"Only one method with name %s is permitted to be declared in %s", (Object[])new Object[]{methodName, declaredClass});
        try {
            return (T)((Method)methods.get(0)).invoke(targetObject, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke method" + methodName + " from " + targetObject, e);
        }
    }
}

