/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.message;

import com.google.protobuf.ByteString;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.core.generated.Payload;
import org.apache.flink.statefun.flink.core.message.MessagePayloadSerializer;

public final class MessagePayloadSerializerKryo
implements MessagePayloadSerializer {
    private KryoSerializer<Object> kryo = new KryoSerializer(Object.class, new ExecutionConfig());
    private DataInputDeserializer source = new DataInputDeserializer();
    private DataOutputSerializer target = new DataOutputSerializer(4096);

    @Override
    public Payload serialize(@Nonnull Object payloadObject) {
        this.target.clear();
        try {
            this.kryo.serialize(payloadObject, (DataOutputView)this.target);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        ByteString serializedBytes = ByteString.copyFrom((byte[])this.target.getSharedBuffer(), (int)0, (int)this.target.length());
        return Payload.newBuilder().setClassName(payloadObject.getClass().getName()).setPayloadBytes(serializedBytes).build();
    }

    @Override
    public Object deserialize(@Nonnull ClassLoader targetClassLoader, @Nonnull Payload payload) {
        this.source.setBuffer(payload.getPayloadBytes().asReadOnlyByteBuffer());
        try {
            return this.kryo.deserialize((DataInputView)this.source);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object copy(@Nonnull ClassLoader targetClassLoader, @Nonnull Object what) {
        this.target.clear();
        try {
            this.kryo.serialize(what, (DataOutputView)this.target);
            this.source.setBuffer(this.target.getSharedBuffer(), 0, this.target.length());
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(targetClassLoader);
            try {
                Object object;
                ClassLoader originalKryoCl = this.kryo.getKryo().getClassLoader();
                this.kryo.getKryo().setClassLoader(targetClassLoader);
                try {
                    object = this.kryo.deserialize((DataInputView)this.source);
                }
                catch (Throwable throwable) {
                    this.kryo.getKryo().setClassLoader(originalKryoCl);
                    throw throwable;
                }
                this.kryo.getKryo().setClassLoader(originalKryoCl);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

