/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.connector.file.table.stream.PartitionTimeCommitPredicate;
import org.apache.flink.connector.file.table.stream.ProcTimeCommitPredicate;

@Internal
public interface PartitionCommitPredicate {
    public boolean isPartitionCommittable(PredicateContext var1);

    public static PredicateContext createPredicateContext(final String partition, final long createProcTime, final long currentProcTime, final long currentWatermark) {
        return new PredicateContext(){

            @Override
            public String partition() {
                return partition;
            }

            @Override
            public long createProcTime() {
                return createProcTime;
            }

            @Override
            public long currentProcTime() {
                return currentProcTime;
            }

            @Override
            public long currentWatermark() {
                return currentWatermark;
            }
        };
    }

    public static PartitionCommitPredicate createPartitionTimeCommitPredicate(Configuration conf, ClassLoader cl, List<String> partitionKeys) {
        return new PartitionTimeCommitPredicate(conf, cl, partitionKeys);
    }

    public static PartitionCommitPredicate createProcTimeCommitPredicate(Configuration conf) {
        return new ProcTimeCommitPredicate(conf);
    }

    public static PartitionCommitPredicate create(Configuration conf, ClassLoader cl, List<String> partitionKeys) {
        FileSystemConnectorOptions.PartitionCommitTriggerType trigger = conf.get(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_TRIGGER);
        switch (trigger) {
            case PARTITION_TIME: {
                return PartitionCommitPredicate.createPartitionTimeCommitPredicate(conf, cl, partitionKeys);
            }
            case PROCESS_TIME: {
                return PartitionCommitPredicate.createProcTimeCommitPredicate(conf);
            }
        }
        throw new UnsupportedOperationException("Unsupported partition commit predicate: " + trigger);
    }

    public static interface PredicateContext {
        public String partition();

        public long createProcTime();

        public long currentProcTime();

        public long currentWatermark();
    }
}

