/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerUtils;
import org.apache.flink.streaming.api.operators.TimerHeapInternalTimer;
import org.apache.flink.util.Preconditions;

public class InternalTimersSnapshot<K, N> {
    private TypeSerializerSnapshot<K> keySerializerSnapshot;
    private TypeSerializerSnapshot<N> namespaceSerializerSnapshot;
    private Set<TimerHeapInternalTimer<K, N>> eventTimeTimers;
    private Set<TimerHeapInternalTimer<K, N>> processingTimeTimers;

    public InternalTimersSnapshot() {
    }

    public InternalTimersSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, @Nullable Set<TimerHeapInternalTimer<K, N>> eventTimeTimers, @Nullable Set<TimerHeapInternalTimer<K, N>> processingTimeTimers) {
        Preconditions.checkNotNull(keySerializer);
        this.keySerializerSnapshot = TypeSerializerUtils.snapshotBackwardsCompatible(keySerializer);
        Preconditions.checkNotNull(namespaceSerializer);
        this.namespaceSerializerSnapshot = TypeSerializerUtils.snapshotBackwardsCompatible(namespaceSerializer);
        this.eventTimeTimers = eventTimeTimers;
        this.processingTimeTimers = processingTimeTimers;
    }

    public TypeSerializerSnapshot<K> getKeySerializerSnapshot() {
        return this.keySerializerSnapshot;
    }

    public void setKeySerializerSnapshot(TypeSerializerSnapshot<K> keySerializerConfigSnapshot) {
        this.keySerializerSnapshot = keySerializerConfigSnapshot;
    }

    public TypeSerializerSnapshot<N> getNamespaceSerializerSnapshot() {
        return this.namespaceSerializerSnapshot;
    }

    public void setNamespaceSerializerSnapshot(TypeSerializerSnapshot<N> namespaceSerializerConfigSnapshot) {
        this.namespaceSerializerSnapshot = namespaceSerializerConfigSnapshot;
    }

    public Set<TimerHeapInternalTimer<K, N>> getEventTimeTimers() {
        return this.eventTimeTimers;
    }

    public void setEventTimeTimers(Set<TimerHeapInternalTimer<K, N>> eventTimeTimers) {
        this.eventTimeTimers = eventTimeTimers;
    }

    public Set<TimerHeapInternalTimer<K, N>> getProcessingTimeTimers() {
        return this.processingTimeTimers;
    }

    public void setProcessingTimeTimers(Set<TimerHeapInternalTimer<K, N>> processingTimeTimers) {
        this.processingTimeTimers = processingTimeTimers;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

