/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.operators.over.frame.SlidingOverFrame;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.types.logical.RowType;

public class RowSlidingOverFrame
extends SlidingOverFrame {
    private final long leftBound;
    private final long rightBound;
    private int inputRightIndex = 0;
    private int inputLeftIndex = 0;

    public RowSlidingOverFrame(RowType inputType, RowType valueType, GeneratedAggsHandleFunction aggsHandleFunction, long leftBound, long rightBound) {
        super(inputType, valueType, aggsHandleFunction);
        this.leftBound = leftBound;
        this.rightBound = rightBound;
    }

    @Override
    public void prepare(ResettableExternalBuffer rows) throws Exception {
        super.prepare(rows);
        this.inputRightIndex = 0;
        this.inputLeftIndex = 0;
    }

    @Override
    public RowData process(int index, RowData current) throws Exception {
        boolean bufferUpdated;
        boolean bl = bufferUpdated = index == 0;
        while (!this.buffer.isEmpty() && (long)this.inputLeftIndex < (long)index + this.leftBound) {
            this.buffer.remove();
            ++this.inputLeftIndex;
            bufferUpdated = true;
        }
        while (this.nextRow != null && (long)this.inputRightIndex <= (long)index + this.rightBound) {
            if ((long)this.inputLeftIndex < (long)index + this.leftBound) {
                ++this.inputLeftIndex;
            } else {
                this.buffer.add(this.inputSer.copy(this.nextRow));
                bufferUpdated = true;
            }
            this.nextRow = OverWindowFrame.getNextOrNull(this.inputIterator);
            ++this.inputRightIndex;
        }
        return this.accumulateBuffer(bufferUpdated);
    }
}

