/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;

@Internal
public final class AnyArgumentTypeStrategy
implements ArgumentTypeStrategy {
    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        return Optional.of(callContext.getArgumentDataTypes().get(argumentPos));
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of("<ANY>");
    }

    public boolean equals(Object o) {
        return this == o || o instanceof AnyArgumentTypeStrategy;
    }

    public int hashCode() {
        return AnyArgumentTypeStrategy.class.hashCode();
    }
}

