/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.io.IOException;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.util.CloseableIterator;

public class RecordReaderIterator<T>
implements CloseableIterator<T> {
    private final RecordReader<T> reader;
    private RecordReader.RecordIterator<T> currentIterator;
    private boolean advanced;
    private T currentResult;

    public RecordReaderIterator(RecordReader<T> reader) {
        this.reader = reader;
        try {
            this.currentIterator = reader.readBatch();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.advanced = false;
        this.currentResult = null;
    }

    public boolean hasNext() {
        if (this.currentIterator == null) {
            return false;
        }
        this.advanceIfNeeded();
        return this.currentResult != null;
    }

    public T next() {
        if (!this.hasNext()) {
            return null;
        }
        this.advanced = false;
        return this.currentResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void advanceIfNeeded() {
        if (this.advanced) {
            return;
        }
        this.advanced = true;
        try {
            do {
                this.currentResult = this.currentIterator.next();
                if (this.currentResult != null) return;
                this.currentIterator.releaseBatch();
                this.currentIterator = this.reader.readBatch();
            } while (this.currentIterator != null);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws Exception {
        if (this.currentIterator != null) {
            this.currentIterator.releaseBatch();
        }
        this.reader.close();
    }
}

