/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.lookup;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.table.data.RowData;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.WriteOptions;

public abstract class RocksDBState<CacheV> {
    protected final RocksDB db;
    protected final WriteOptions writeOptions;
    protected final ColumnFamilyHandle columnFamily;
    protected final TypeSerializer<RowData> keySerializer;
    protected final TypeSerializer<RowData> valueSerializer;
    protected final DataOutputSerializer keyOutView;
    protected final DataInputDeserializer valueInputView;
    protected final DataOutputSerializer valueOutputView;
    protected final Cache<ByteArray, CacheV> cache;

    public RocksDBState(RocksDB db, ColumnFamilyHandle columnFamily, TypeSerializer<RowData> keySerializer, TypeSerializer<RowData> valueSerializer, long lruCacheSize) {
        this.db = db;
        this.columnFamily = columnFamily;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyOutView = new DataOutputSerializer(32);
        this.valueInputView = new DataInputDeserializer();
        this.valueOutputView = new DataOutputSerializer(32);
        this.writeOptions = new WriteOptions().setDisableWAL(true);
        this.cache = CacheBuilder.newBuilder().maximumSize(lruCacheSize).build();
    }

    protected byte[] serializeKey(RowData key) throws IOException {
        this.keyOutView.clear();
        this.keySerializer.serialize((Object)key, (DataOutputView)this.keyOutView);
        return this.keyOutView.getCopyOfBuffer();
    }

    protected ByteArray wrap(byte[] bytes) {
        return new ByteArray(bytes);
    }

    protected Reference ref(byte[] bytes) {
        return new Reference(bytes);
    }

    protected static class Reference {
        @Nullable
        protected final byte[] bytes;

        protected Reference(@Nullable byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean isPresent() {
            return this.bytes != null;
        }
    }

    protected static class ByteArray {
        protected final byte[] bytes;

        protected ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteArray byteArray = (ByteArray)o;
            return Arrays.equals(this.bytes, byteArray.bytes);
        }
    }
}

