/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.FilterPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class ColumnPrefixFilter
extends ScanFilter {
    private static final byte[] NAME = Bytes.ISO88591("org.apache.hadoop.hbase.filter.ColumnPrefixFilter");
    private final byte[] prefix;

    public ColumnPrefixFilter(String prefix) {
        this(Bytes.UTF8(prefix));
    }

    public ColumnPrefixFilter(byte[] prefix) {
        if (prefix.length == 0) {
            throw new IllegalArgumentException("Empty prefix");
        }
        this.prefix = prefix;
    }

    @Override
    byte[] serialize() {
        return FilterPB.ColumnPrefixFilter.newBuilder().setPrefix(Bytes.wrap(this.prefix)).build().toByteArray();
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    int predictSerializedSize() {
        return 1 + NAME.length + 3 + this.prefix.length;
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)NAME.length));
        buf.writeBytes(NAME);
        HBaseRpc.writeByteArray(buf, this.prefix);
    }

    public String toString() {
        return "ColumnPrefixFilter(" + Bytes.pretty(this.prefix) + ")";
    }
}

