/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import org.apache.curator.framework.CuratorFramework;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.node.AbstractZooKeeperConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticZooKeeperConfigurationProvider
extends AbstractZooKeeperConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticZooKeeperConfigurationProvider.class);

    public StaticZooKeeperConfigurationProvider(String agentName, String zkConnString, String basePath) {
        super(agentName, zkConnString, basePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FlumeConfiguration getFlumeConfiguration() {
        FlumeConfiguration flumeConfiguration;
        CuratorFramework cf = this.createClient();
        cf.start();
        try {
            byte[] data = (byte[])cf.getData().forPath(this.basePath + "/" + this.getAgentName());
            flumeConfiguration = this.configFromBytes(data);
        }
        catch (Throwable throwable) {
            try {
                cf.close();
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Error getting configuration info from Zookeeper", (Throwable)e);
                throw new FlumeException((Throwable)e);
            }
        }
        cf.close();
        return flumeConfiguration;
    }
}

