/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.tools;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.file.CorruptEventException;
import org.apache.flume.channel.file.EventUtils;
import org.apache.flume.channel.file.LogFile;
import org.apache.flume.channel.file.LogFileV3;
import org.apache.flume.channel.file.LogRecord;
import org.apache.flume.channel.file.Serialization;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.apache.flume.tools.EventValidator;
import org.apache.flume.tools.FlumeTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelIntegrityTool
implements FlumeTool {
    public static final Logger LOG = LoggerFactory.getLogger(FileChannelIntegrityTool.class);
    private final List<File> dataDirs = new ArrayList<File>();
    private EventValidator eventValidator = EventValidator.NOOP_VALIDATOR;
    private long totalPutEvents;
    private long invalidEvents;
    private long eventsWithException;
    private long corruptEvents;
    private long validEvents;
    private long totalChannelEvents;

    @Override
    public void run(String[] args) throws IOException, ParseException {
        boolean shouldContinue = this.parseCommandLineOpts(args);
        if (!shouldContinue) {
            LOG.error("Could not parse command line options. Exiting ...");
            System.exit(1);
        }
        for (File dataDir : this.dataDirs) {
            File[] dataFiles = dataDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.endsWith(".meta") && !name.endsWith(".tmp") && !name.endsWith(".meta.old") && !name.equals("in_use.lock");
                }
            });
            if (dataFiles == null || dataFiles.length <= 0) continue;
            for (File dataFile : dataFiles) {
                LOG.info("Checking for corruption in " + dataFile.toString());
                LogFileV3.SequentialReader reader = new LogFileV3.SequentialReader(dataFile, null, true);
                LogFile.OperationRecordUpdater updater = new LogFile.OperationRecordUpdater(dataFile);
                boolean fileDone = false;
                boolean fileBackedup = false;
                while (!fileDone) {
                    long eventPosition = 0L;
                    try {
                        eventPosition = reader.getPosition();
                        LogRecord record = reader.next();
                        ++this.totalChannelEvents;
                        if (record != null) {
                            TransactionEventRecord recordEvent = record.getEvent();
                            Event event = EventUtils.getEventFromTransactionEvent((TransactionEventRecord)recordEvent);
                            if (event == null) continue;
                            ++this.totalPutEvents;
                            try {
                                if (!this.eventValidator.validateEvent(event)) {
                                    if (!fileBackedup) {
                                        Serialization.copyFile((File)dataFile, (File)new File(dataFile.getParent(), dataFile.getName() + ".bak"));
                                        fileBackedup = true;
                                    }
                                    ++this.invalidEvents;
                                    updater.markRecordAsNoop(eventPosition);
                                    continue;
                                }
                                ++this.validEvents;
                            }
                            catch (Exception e) {
                                System.err.println("Encountered Exception while validating event, marking as invalid");
                                updater.markRecordAsNoop(eventPosition);
                                ++this.eventsWithException;
                            }
                            continue;
                        }
                        fileDone = true;
                    }
                    catch (CorruptEventException e) {
                        ++this.corruptEvents;
                        ++this.totalChannelEvents;
                        LOG.warn("Corruption found in " + dataFile.toString() + " at " + eventPosition);
                        if (!fileBackedup) {
                            Serialization.copyFile((File)dataFile, (File)new File(dataFile.getParent(), dataFile.getName() + ".bak"));
                            fileBackedup = true;
                        }
                        updater.markRecordAsNoop(eventPosition);
                    }
                }
                updater.close();
                reader.close();
            }
        }
        this.printSummary();
    }

    private boolean parseCommandLineOpts(String[] args) throws ParseException {
        String[] dataDirStr;
        Options options = new Options();
        options.addOption("l", "dataDirs", true, "Comma-separated list of data directories which the tool must verify. This option is mandatory").addOption("h", "help", false, "Display help").addOption("e", "eventValidator", true, "Fully Qualified Name of Event Validator Implementation");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"custom properties");
        Option property = OptionBuilder.create((String)"D");
        options.addOption(property);
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(options, args);
        if (commandLine.hasOption("help")) {
            new HelpFormatter().printHelp("bin/flume-ng tool fcintegritytool ", options, true);
            return false;
        }
        if (!commandLine.hasOption("dataDirs")) {
            new HelpFormatter().printHelp("bin/flume-ng tool fcintegritytool ", "", options, "dataDirs is required.", true);
            return false;
        }
        for (String dataDir : dataDirStr = commandLine.getOptionValue("dataDirs").split(",")) {
            File f = new File(dataDir);
            if (!f.exists()) {
                throw new FlumeException("Data directory, " + dataDir + " does not exist.");
            }
            this.dataDirs.add(f);
        }
        if (commandLine.hasOption("eventValidator")) {
            try {
                Class<?> eventValidatorClassName = Class.forName(commandLine.getOptionValue("eventValidator"));
                EventValidator.Builder eventValidatorBuilder = (EventValidator.Builder)eventValidatorClassName.newInstance();
                Properties systemProperties = commandLine.getOptionProperties("D");
                Context context = new Context();
                Set<String> keys = systemProperties.stringPropertyNames();
                for (String key : keys) {
                    context.put(key, systemProperties.getProperty(key));
                }
                eventValidatorBuilder.configure(context);
                this.eventValidator = eventValidatorBuilder.build();
            }
            catch (Exception e) {
                System.err.println(String.format("Could find class %s in lib folder", commandLine.getOptionValue("eventValidator")));
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void printSummary() {
        System.out.println("---------- Summary --------------------");
        System.out.println("Number of Events in the Channel = " + this.totalChannelEvents++);
        System.out.println("Number of Put Events Processed = " + this.totalPutEvents);
        System.out.println("Number of Valid Put Events = " + this.validEvents);
        System.out.println("Number of Invalid Put Events = " + this.invalidEvents);
        System.out.println("Number of Put Events that threw Exception during validation = " + this.eventsWithException);
        System.out.println("Number of Corrupt Events = " + this.corruptEvents);
        System.out.println("---------------------------------------");
    }
}

