/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.ToDataException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.client.NoAvailableLocatorsException;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.cache.client.internal.ConnectionSource;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.LocatorDiscoveryCallback;
import org.apache.geode.cache.client.internal.LocatorDiscoveryCallbackAdapter;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.cache.client.internal.locator.ClientConnectionResponse;
import org.apache.geode.cache.client.internal.locator.ClientReplacementRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersResponse;
import org.apache.geode.cache.client.internal.locator.LocatorListRequest;
import org.apache.geode.cache.client.internal.locator.LocatorListResponse;
import org.apache.geode.cache.client.internal.locator.QueueConnectionRequest;
import org.apache.geode.cache.client.internal.locator.QueueConnectionResponse;
import org.apache.geode.cache.client.internal.locator.ServerLocationRequest;
import org.apache.geode.cache.client.internal.locator.ServerLocationResponse;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class AutoConnectionSourceImpl
implements ConnectionSource {
    private static final Logger logger = LogService.getLogger();
    private TcpClient tcpClient;
    @Immutable
    private static final LocatorListRequest LOCATOR_LIST_REQUEST = new LocatorListRequest();
    @Immutable
    private static final Comparator<HostAndPort> SOCKET_ADDRESS_COMPARATOR = (address, otherAddress) -> {
        InetSocketAddress inetSocketAddress = address.getSocketInetAddress();
        InetSocketAddress otherInetSocketAddress = otherAddress.getSocketInetAddress();
        if (inetSocketAddress.getHostString() == null || otherInetSocketAddress.getHostString() == null) {
            return 0;
        }
        int result = inetSocketAddress.getHostString().compareTo(otherInetSocketAddress.getHostString());
        if (result != 0) {
            return result;
        }
        return inetSocketAddress.getPort() - otherInetSocketAddress.getPort();
    };
    private final List<HostAndPort> initialLocators;
    private final String serverGroup;
    private AtomicReference<LocatorList> locators = new AtomicReference();
    private AtomicReference<LocatorList> onlineLocators = new AtomicReference();
    protected InternalPool pool;
    private final int connectionTimeout;
    private long locatorUpdateInterval;
    private volatile LocatorDiscoveryCallback locatorCallback = new LocatorDiscoveryCallbackAdapter();
    private volatile boolean isBalanced = true;
    private final Map<InetSocketAddress, Exception> locatorState = new HashMap<InetSocketAddress, Exception>();

    public AutoConnectionSourceImpl(List<HostAndPort> contacts, String serverGroup, int handshakeTimeout, SocketFactory socketFactory) {
        this.locators.set(new LocatorList(new ArrayList<HostAndPort>(contacts)));
        this.onlineLocators.set(new LocatorList(Collections.emptyList()));
        this.initialLocators = Collections.unmodifiableList(this.locators.get().getLocatorAddresses());
        this.connectionTimeout = handshakeTimeout;
        this.serverGroup = serverGroup;
        this.tcpClient = new TcpClient((TcpSocketCreator)SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR), InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer(), socketFactory::createSocket);
    }

    @Override
    public boolean isBalanced() {
        return this.isBalanced;
    }

    @Override
    public List<ServerLocation> getAllServers() {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        GetAllServersRequest request = new GetAllServersRequest(this.serverGroup);
        GetAllServersResponse response = (GetAllServersResponse)this.queryLocators(request);
        if (response != null) {
            return response.getServers();
        }
        return null;
    }

    @Override
    public ServerLocation findReplacementServer(ServerLocation currentServer, Set<ServerLocation> excludedServers) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        ClientReplacementRequest request = new ClientReplacementRequest(currentServer, excludedServers, this.serverGroup);
        ClientConnectionResponse response = (ClientConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + this.locators);
        }
        return response.getServer();
    }

    public ServerLocation findServer(Set excludedServers) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        ClientConnectionRequest request = new ClientConnectionRequest(excludedServers, this.serverGroup);
        ClientConnectionResponse response = (ClientConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + this.locators);
        }
        return response.getServer();
    }

    @Override
    public List<ServerLocation> findServersForQueue(Set<ServerLocation> excludedServers, int numServers, ClientProxyMembershipID proxyId, boolean findDurableQueue) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return new ArrayList<ServerLocation>();
        }
        QueueConnectionRequest request = new QueueConnectionRequest(proxyId, numServers, excludedServers, this.serverGroup, findDurableQueue);
        QueueConnectionResponse response = (QueueConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + this.locators);
        }
        return response.getServers();
    }

    @Override
    public List<InetSocketAddress> getOnlineLocators() {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<InetSocketAddress>(this.onlineLocators.get().getLocators()));
    }

    private ServerLocationResponse queryOneLocator(HostAndPort locator, ServerLocationRequest request) {
        return this.queryOneLocatorUsingConnection(locator, request, this.tcpClient);
    }

    ServerLocationResponse queryOneLocatorUsingConnection(HostAndPort locator, ServerLocationRequest request, TcpClient locatorConnection) {
        Object returnObj = null;
        try {
            this.pool.getStats().incLocatorRequests();
            returnObj = locatorConnection.requestToServer(locator, (Object)request, this.connectionTimeout, true);
            ServerLocationResponse response = (ServerLocationResponse)returnObj;
            this.pool.getStats().incLocatorResponses();
            if (response != null) {
                this.reportLiveLocator(locator.getSocketInetAddress());
            }
            return response;
        }
        catch (IOException | ToDataException ioe) {
            if (ioe instanceof ToDataException) {
                logger.warn("Encountered ToDataException when communicating with a locator.  This is expected if the locator is shutting down.", (Throwable)ioe);
            }
            this.reportDeadLocator(locator.getSocketInetAddress(), ioe);
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.warn("Received exception from locator {}", (Object)locator, (Object)e);
            return null;
        }
        catch (ClassCastException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received odd response object from the locator: {}", returnObj);
            }
            this.reportDeadLocator(locator.getSocketInetAddress(), e);
            return null;
        }
    }

    private ServerLocationResponse queryLocators(ServerLocationRequest request) {
        ServerLocationResponse response;
        Iterator<HostAndPort> controllerItr = this.locators.get().iterator();
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            HostAndPort hostAddress = controllerItr.next();
            if (isDebugEnabled) {
                logger.debug("Sending query to locator {}: {}", (Object)hostAddress, (Object)request);
            }
            response = this.queryOneLocator(hostAddress, request);
            if (!isDebugEnabled) continue;
            logger.debug("Received query response from locator {}: {}", (Object)hostAddress, (Object)response);
        } while (controllerItr.hasNext() && (response == null || !response.hasResult()));
        return response;
    }

    private void updateLocatorList(LocatorListResponse response) {
        if (response == null) {
            return;
        }
        this.isBalanced = response.isBalanced();
        List<ServerLocation> locatorResponse = response.getLocators();
        ArrayList<HostAndPort> newLocatorAddresses = new ArrayList<HostAndPort>(locatorResponse.size());
        ArrayList<HostAndPort> newOnlineLocators = new ArrayList<HostAndPort>(locatorResponse.size());
        HashSet<HostAndPort> badLocators = new HashSet<HostAndPort>(this.initialLocators);
        for (ServerLocation locator : locatorResponse) {
            HostAndPort hostAddress = new HostAndPort(locator.getHostName(), locator.getPort());
            newLocatorAddresses.add(hostAddress);
            newOnlineLocators.add(hostAddress);
            badLocators.remove(hostAddress);
        }
        this.addbadLocators(newLocatorAddresses, badLocators);
        LocatorList newLocatorList = new LocatorList(newLocatorAddresses);
        LocatorList oldLocators = this.locators.getAndSet(newLocatorList);
        this.onlineLocators.set(new LocatorList(newOnlineLocators));
        this.pool.getStats().setLocatorCount(newLocatorAddresses.size());
        if (logger.isInfoEnabled() || !this.locatorCallback.getClass().equals(LocatorDiscoveryCallbackAdapter.class)) {
            List<InetSocketAddress> newLocators = newLocatorList.getLocators();
            ArrayList<InetSocketAddress> removedLocators = new ArrayList<InetSocketAddress>(oldLocators.getLocators());
            removedLocators.removeAll(newLocators);
            ArrayList<InetSocketAddress> addedLocators = new ArrayList<InetSocketAddress>(newLocators);
            addedLocators.removeAll(oldLocators.getLocators());
            if (!addedLocators.isEmpty()) {
                this.locatorCallback.locatorsDiscovered(Collections.unmodifiableList(addedLocators));
                logger.info("AutoConnectionSource discovered new locators {}", addedLocators);
            }
            if (!removedLocators.isEmpty()) {
                this.locatorCallback.locatorsRemoved(Collections.unmodifiableList(removedLocators));
                logger.info("AutoConnectionSource dropping previously discovered locators {}", removedLocators);
            }
        }
    }

    protected void addbadLocators(List<HostAndPort> newLocators, Set<HostAndPort> badLocators) {
        for (HostAndPort badloc : badLocators) {
            boolean addIt = true;
            for (HostAndPort goodloc : newLocators) {
                boolean isSameHost = badloc.getHostName().equals(goodloc.getHostName());
                if (!isSameHost || badloc.getPort() != goodloc.getPort()) continue;
                addIt = false;
                break;
            }
            if (!addIt) continue;
            newLocators.add(badloc);
        }
    }

    @Override
    public void start(InternalPool pool) {
        this.pool = pool;
        pool.getStats().setInitialContacts(this.locators.get().size());
        this.locatorUpdateInterval = Long.getLong("gemfire.LOCATOR_UPDATE_INTERVAL", pool.getPingInterval());
        if (this.locatorUpdateInterval > 0L) {
            pool.getBackgroundProcessor().scheduleWithFixedDelay(new UpdateLocatorListTask(), 0L, this.locatorUpdateInterval, TimeUnit.MILLISECONDS);
            logger.info("AutoConnectionSource UpdateLocatorListTask started with interval={} ms.", new Object[]{this.locatorUpdateInterval});
        }
    }

    @Override
    public void stop() {
    }

    public void setLocatorDiscoveryCallback(LocatorDiscoveryCallback callback) {
        this.locatorCallback = callback;
    }

    private synchronized void reportLiveLocator(InetSocketAddress l) {
        Object prevState = this.locatorState.put(l, null);
        if (prevState != null) {
            logger.info("Communication has been restored with locator {}.", (Object)l);
        }
    }

    private synchronized void reportDeadLocator(InetSocketAddress l, Exception ex) {
        Exception prevState = this.locatorState.put(l, ex);
        if (prevState == null) {
            if (ex instanceof ConnectException) {
                logger.info("locator {} is not running.", (Object)l, (Object)ex);
            } else {
                logger.info("Communication with locator {} failed", (Object)l, (Object)ex);
            }
        }
    }

    long getLocatorUpdateInterval() {
        return this.locatorUpdateInterval;
    }

    protected class UpdateLocatorListTask
    extends PoolImpl.PoolTask {
        protected UpdateLocatorListTask() {
        }

        @Override
        public void run2() {
            if (AutoConnectionSourceImpl.this.pool.getCancelCriterion().isCancelInProgress()) {
                return;
            }
            LocatorListResponse response = (LocatorListResponse)AutoConnectionSourceImpl.this.queryLocators(LOCATOR_LIST_REQUEST);
            AutoConnectionSourceImpl.this.updateLocatorList(response);
        }
    }

    private static class LocatorList {
        protected final List<HostAndPort> locators;
        AtomicInteger currentLocatorIndex = new AtomicInteger();

        LocatorList(List<HostAndPort> locators) {
            locators.sort(SOCKET_ADDRESS_COMPARATOR);
            this.locators = Collections.unmodifiableList(locators);
        }

        public List<InetSocketAddress> getLocators() {
            ArrayList<InetSocketAddress> locs = new ArrayList<InetSocketAddress>();
            for (HostAndPort la : this.locators) {
                locs.add(la.getSocketInetAddress());
            }
            return locs;
        }

        List<HostAndPort> getLocatorAddresses() {
            return this.locators;
        }

        public int size() {
            return this.locators.size();
        }

        public Iterator<HostAndPort> iterator() {
            return new LocatorIterator();
        }

        public String toString() {
            return this.locators.toString();
        }

        protected class LocatorIterator
        implements Iterator<HostAndPort> {
            private int startLocator;
            private int locatorNum;

            protected LocatorIterator() {
                this.startLocator = LocatorList.this.currentLocatorIndex.get();
                this.locatorNum = 0;
            }

            @Override
            public boolean hasNext() {
                return this.locatorNum < LocatorList.this.locators.size();
            }

            @Override
            public HostAndPort next() {
                if (!this.hasNext()) {
                    return null;
                }
                int index = (this.locatorNum + this.startLocator) % LocatorList.this.locators.size();
                HostAndPort nextLocator = LocatorList.this.locators.get(index);
                LocatorList.this.currentLocatorIndex.set(index);
                ++this.locatorNum;
                return nextLocator;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

