/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelCriterion;
import org.apache.geode.Statistics;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.statistics.StatSamplerStats;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CallbackSampler {
    private static final Logger logger = LogService.getLogger();
    private StatisticsManager statisticsManager;
    private final CancelCriterion cancelCriterion;
    private long sampleIntervalNanos;
    private ScheduledExecutorService executor;
    private final StatSamplerStats statSamplerStats;

    public CallbackSampler(CancelCriterion cancelCriterion, StatSamplerStats statSamplerStats) {
        this.cancelCriterion = cancelCriterion;
        this.statSamplerStats = statSamplerStats;
    }

    public void start(StatisticsManager statisticsManager, int sampleInterval, TimeUnit timeUnit) {
        ScheduledExecutorService executor = LoggingExecutors.newSingleThreadScheduledExecutor((String)"CallbackSampler");
        this.start(executor, statisticsManager, sampleInterval, timeUnit);
    }

    void start(ScheduledExecutorService executor, StatisticsManager statisticsManager, int sampleInterval, TimeUnit timeUnit) {
        this.stop();
        this.statisticsManager = statisticsManager;
        this.executor = executor;
        executor.scheduleAtFixedRate(() -> this.sampleCallbacks(), sampleInterval, sampleInterval, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleCallbacks() {
        if (this.cancelCriterion.isCancelInProgress()) {
            this.executor.shutdown();
        }
        int errors = 0;
        int suppliers = 0;
        long start = System.nanoTime();
        try {
            for (Statistics stats : this.statisticsManager.getStatsList()) {
                StatisticsImpl statistics = (StatisticsImpl)stats;
                errors += statistics.updateSuppliedValues();
                suppliers += statistics.getSupplierCount();
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
        }
        catch (Throwable throwable) {
            logger.error("Error invoking statistic suppliers", throwable);
        }
        finally {
            long end = System.nanoTime();
            this.statSamplerStats.incSampleCallbackDuration(TimeUnit.NANOSECONDS.toMillis(end - start));
            this.statSamplerStats.incSampleCallbackErrors(errors);
            this.statSamplerStats.setSampleCallbacks(suppliers);
        }
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

