/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.internal;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.serialization.BasicSerializable;
import org.apache.geode.internal.serialization.DSCODE;
import org.apache.geode.internal.serialization.DSFIDNotFoundException;
import org.apache.geode.internal.serialization.DSFIDSerializer;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.DscodeHelper;
import org.apache.geode.internal.serialization.ObjectDeserializer;
import org.apache.geode.internal.serialization.ObjectSerializer;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.SerializationVersions;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.internal.DeserializationContextImpl;
import org.apache.geode.internal.serialization.internal.SerializationContextImpl;

public class DSFIDSerializerImpl
implements DSFIDSerializer {
    @Immutable
    private final Constructor<?>[] dsfidMap = new Constructor[256];
    @Immutable(value="This maybe should be wrapped in an unmodifiableMap?")
    private final Int2ObjectOpenHashMap<Constructor<?>> dsfidMap2 = new Int2ObjectOpenHashMap(800);
    private final ObjectSerializer objectSerializer;
    private final ObjectDeserializer objectDeserializer;

    public DSFIDSerializerImpl() {
        this.objectSerializer = this.createDefaultObjectSerializer();
        this.objectDeserializer = this.createDefaultObjectDeserializer();
    }

    public DSFIDSerializerImpl(ObjectSerializer objectSerializer, ObjectDeserializer objectDeserializer) {
        this.objectSerializer = objectSerializer == null ? this.createDefaultObjectSerializer() : objectSerializer;
        this.objectDeserializer = objectDeserializer == null ? this.createDefaultObjectDeserializer() : objectDeserializer;
    }

    private ObjectSerializer createDefaultObjectSerializer() {
        return new ObjectSerializer(){

            @Override
            public void writeObject(Object obj, DataOutput output) throws IOException {
                if (obj != null && !(obj instanceof BasicSerializable)) {
                    throw new NotSerializableException("object with class " + obj.getClass().getName() + " is not serializable via DSFIDSerializerImpl");
                }
                DSFIDSerializerImpl.this.write((BasicSerializable)obj, output);
            }

            @Override
            public void invokeToData(Object ds, DataOutput out) throws IOException {
                DSFIDSerializerImpl.this.invokeToData(ds, out);
            }
        };
    }

    private ObjectDeserializer createDefaultObjectDeserializer() {
        return new ObjectDeserializer(){

            @Override
            public <T> T readObject(DataInput input) throws IOException, ClassNotFoundException {
                return (T)DSFIDSerializerImpl.this.readDSFID(input);
            }

            @Override
            public void invokeFromData(Object ds, DataInput in) throws IOException, ClassNotFoundException {
                DSFIDSerializerImpl.this.invokeFromData(ds, in);
            }
        };
    }

    @Override
    public ObjectSerializer getObjectSerializer() {
        return this.objectSerializer;
    }

    @Override
    public ObjectDeserializer getObjectDeserializer() {
        return this.objectDeserializer;
    }

    @Override
    public void writeDSFIDHeader(int dsfid, DataOutput out) throws IOException {
        if (dsfid == 0) {
            throw new IllegalStateException("attempted to serialize ILLEGAL dsfid");
        }
        if (dsfid <= 127 && dsfid >= -128) {
            out.writeByte(DSCODE.DS_FIXED_ID_BYTE.toByte());
            out.writeByte(dsfid);
        } else if (dsfid <= Short.MAX_VALUE && dsfid >= Short.MIN_VALUE) {
            out.writeByte(DSCODE.DS_FIXED_ID_SHORT.toByte());
            out.writeShort(dsfid);
        } else {
            out.writeByte(DSCODE.DS_FIXED_ID_INT.toByte());
            out.writeInt(dsfid);
        }
    }

    @Override
    public void write(BasicSerializable bs, DataOutput out) throws IOException {
        this.writeMetaData(bs, out);
        if (bs != null) {
            this.invokeToData(bs, out);
        }
    }

    private void writeMetaData(BasicSerializable bs, DataOutput out) throws IOException {
        if (bs == null) {
            out.writeByte(DSCODE.NULL.toByte());
            return;
        }
        if (bs instanceof DataSerializableFixedID) {
            DataSerializableFixedID dsfid = (DataSerializableFixedID)bs;
            int id = dsfid.getDSFID();
            if (id == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("NO_FIXED_ID is not supported by BasicDSFIDSerializer - use InternalDataSerializer instead: " + dsfid.getClass().getName());
            }
            this.writeDSFIDHeader(id, out);
        } else {
            out.writeByte(DSCODE.DATA_SERIALIZABLE.toByte());
            Class<?> c = bs.getClass();
            StaticSerialization.writeClass(c, out);
        }
    }

    @Override
    public void invokeToData(Object ds, DataOutput out) throws IOException {
        SerializationContextImpl context = new SerializationContextImpl(out, this);
        boolean isDSFID = ds instanceof DataSerializableFixedID;
        if (!isDSFID) {
            if (ds instanceof BasicSerializable) {
                ((BasicSerializable)ds).toData(out, context);
                return;
            }
            throw new IllegalArgumentException("Expected a DataSerializableFixedID but found " + ds.getClass().getName());
        }
        try {
            SerializationVersions sv;
            Version[] versions;
            boolean invoked = false;
            Version v = context.getSerializationVersion();
            if (!Version.CURRENT.equals(v) && (versions = (sv = (SerializationVersions)ds).getSerializationVersions()) != null) {
                for (Version version : versions) {
                    if (v.compareTo(version) >= 0) continue;
                    ds.getClass().getMethod("toDataPre_" + version.getMethodSuffix(), DataOutput.class, SerializationContext.class).invoke(ds, out, context);
                    invoked = true;
                    break;
                }
            }
            if (!invoked) {
                ((DataSerializableFixedID)ds).toData(out, context);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException("problem invoking toData method on object of class" + ds.getClass().getName(), e);
        }
    }

    private Object readDSFID(DataInput in) throws IOException, ClassNotFoundException {
        DSFIDSerializerImpl.checkIn(in);
        DSCODE dsHeaderType = DscodeHelper.toDSCODE(in.readByte());
        if (dsHeaderType == DSCODE.NULL) {
            return null;
        }
        return this.readDSFID(in, dsHeaderType);
    }

    private Object readDSFID(DataInput in, DSCODE dscode) throws IOException, ClassNotFoundException {
        switch (dscode) {
            case DS_FIXED_ID_BYTE: {
                return this.create(in.readByte(), in);
            }
            case DS_FIXED_ID_SHORT: {
                return this.create(in.readShort(), in);
            }
            case DS_NO_FIXED_ID: {
                throw new IllegalStateException("DS_NO_FIXED_ID is not supported in readDSFID - use InternalDataSerializer instead");
            }
            case DS_FIXED_ID_INT: {
                return this.create(in.readInt(), in);
            }
            case DATA_SERIALIZABLE: {
                return this.readDataSerializable(in);
            }
        }
        throw new IllegalStateException("unexpected byte: " + (Object)((Object)dscode) + " while reading dsfid");
    }

    private int readDSFIDHeader(DataInput in, DSCODE dscode) throws IOException {
        switch (dscode) {
            case DS_FIXED_ID_BYTE: {
                return in.readByte();
            }
            case DS_FIXED_ID_SHORT: {
                return in.readShort();
            }
            case DS_FIXED_ID_INT: {
                return in.readInt();
            }
        }
        throw new IllegalStateException("unexpected byte: " + (Object)((Object)dscode) + " while reading dsfid");
    }

    @Override
    public int readDSFIDHeader(DataInput in) throws IOException {
        DSFIDSerializerImpl.checkIn(in);
        return this.readDSFIDHeader(in, DscodeHelper.toDSCODE(in.readByte()));
    }

    public static void checkIn(DataInput in) {
        if (in == null) {
            throw new NullPointerException("Null DataInput");
        }
    }

    @Override
    public void invokeFromData(Object ds, DataInput in) throws IOException, ClassNotFoundException {
        block7: {
            DeserializationContextImpl context = new DeserializationContextImpl(in, this);
            try {
                SerializationVersions vds;
                Version[] versions;
                boolean invoked = false;
                Version v = context.getSerializationVersion();
                if (!Version.CURRENT.equals(v) && ds instanceof SerializationVersions && (versions = (vds = (SerializationVersions)ds).getSerializationVersions()) != null) {
                    for (Version version : versions) {
                        if (v.compareTo(version) >= 0) continue;
                        ds.getClass().getMethod("fromDataPre_" + version.getMethodSuffix(), DataInput.class, DeserializationContext.class).invoke(ds, in, context);
                        invoked = true;
                        break;
                    }
                }
                if (invoked) break block7;
                if (ds instanceof BasicSerializable) {
                    ((BasicSerializable)ds).fromData(in, context);
                    break block7;
                }
                throw new IOException("problem invoking fromData method on object of class" + ds.getClass().getName());
            }
            catch (EOFException | ClassNotFoundException | SocketException ex) {
                throw ex;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new IOException(String.format("Could not create an instance of %s .", ds.getClass().getName()), ex);
            }
        }
    }

    @Override
    public void registerDSFID(int dsfid, Class<?> dsfidClass) {
        try {
            Constructor<?> cons = dsfidClass.getConstructor(null);
            cons.setAccessible(true);
            if (!cons.isAccessible()) {
                throw new IllegalArgumentException("default constructor not accessible for DSFID=" + dsfid + ": " + dsfidClass);
            }
            if (dsfid >= -128 && dsfid <= 127) {
                this.dsfidMap[dsfid + 127 + 1] = cons;
            } else {
                this.dsfidMap2.put(dsfid, cons);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Unable to find a default constructor for " + dsfidClass, nsme);
        }
    }

    @Override
    public Object create(int dsfid, DataInput in) throws IOException, ClassNotFoundException {
        Constructor<?> cons = dsfid >= -128 && dsfid <= 127 ? this.dsfidMap[dsfid + 127 + 1] : this.dsfidMap2.get(dsfid);
        if (cons != null) {
            try {
                Object ds = cons.newInstance(null);
                this.invokeFromData(ds, in);
                return ds;
            }
            catch (IllegalAccessException | InstantiationException ie) {
                throw new IOException(ie.getMessage(), ie);
            }
            catch (InvocationTargetException ite) {
                Throwable targetEx = ite.getTargetException();
                if (targetEx instanceof IOException) {
                    throw (IOException)targetEx;
                }
                if (targetEx instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)targetEx;
                }
                throw new IOException(ite.getMessage(), targetEx);
            }
        }
        throw new DSFIDNotFoundException("Unknown DataSerializableFixedID: " + dsfid, dsfid);
    }

    private Object readDataSerializable(DataInput in) throws IOException, ClassNotFoundException {
        Class<?> c = StaticSerialization.readClass(in);
        try {
            Constructor<?> init = c.getConstructor(new Class[0]);
            init.setAccessible(true);
            Object o = init.newInstance(new Object[0]);
            this.invokeFromData(o, in);
            return o;
        }
        catch (EOFException | SocketException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(String.format("Could not create an instance of %s .", c.getName()), ex);
        }
    }

    public Constructor<?>[] getDsfidmap() {
        return this.dsfidMap;
    }

    public Int2ObjectOpenHashMap<Constructor<?>> getDsfidmap2() {
        return this.dsfidMap2;
    }

    @Override
    public SerializationContext createSerializationContext(DataOutput dataOutput) {
        return new SerializationContextImpl(dataOutput, this);
    }

    @Override
    public DeserializationContext createDeserializationContext(DataInput dataInput) {
        return new DeserializationContextImpl(dataInput, this);
    }
}

