/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.Unreferenced;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteStreamServer<StreamServerType, StreamType>
implements Remote,
Unreferenced,
Closeable,
Serializable {
    protected static final Log LOG = LogFactory.getLog(RemoteStreamServer.class);
    private static final long serialVersionUID = 20080212L;
    protected static final int INITIAL_INVALID_SEQUENCE_ID = -1;
    protected static final int INITIAL_VALID_SEQUENCE_ID = 0;
    private static final Set<Object> _hardRefSet = Collections.synchronizedSet(new HashSet());
    private final transient AtomicReference<State> _state = new AtomicReference<State>(State.OPEN);
    protected transient RemoteStreamMonitor<StreamServerType> _monitor;
    private transient RemoteStreamExporter _exporter;
    private volatile transient StreamType _writeReplacement;

    public RemoteStreamServer(RemoteStreamMonitor<StreamServerType> monitor) {
        this._monitor = monitor;
    }

    public StreamType export() throws RemoteException {
        return RemoteStreamExporter.getInstance().export(this);
    }

    public synchronized void exported(RemoteStreamExporter exporter) throws RemoteException {
        if (this._exporter != null) {
            throw new IllegalStateException("Re-exporting still exported stream " + this);
        }
        this._exporter = exporter;
        if (!HardRefMonitor.class.isInstance(this._monitor)) {
            this._monitor = new HardRefMonitor(this._monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void unexport() {
        this._writeReplacement = null;
        try {
            if (HardRefMonitor.class.isInstance(this._monitor)) {
                ((HardRefMonitor)HardRefMonitor.class.cast(this._monitor)).cleanup();
            }
            if (this._exporter != null) {
                this._exporter.unexport(this);
            } else {
                LOG.info((Object)("Unexporting object " + this + " which was not exported"));
            }
        }
        finally {
            this._exporter = null;
        }
    }

    @Override
    public void unreferenced() {
        block2: {
            try {
                this.finish(false, false);
            }
            catch (IOException ignored) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Ignoring exception while closing unreferenced stream", (Throwable)ignored);
            }
        }
    }

    public final boolean isClosed() {
        return this._state.get() == State.CLOSED;
    }

    @Override
    public final void close() {
        this.unreferenced();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void finish(boolean remoteClose, boolean transferSuccess) throws IOException {
        State oldState = this._state.getAndSet(State.CLOSED);
        if (oldState == State.CLOSED) {
            return;
        }
        boolean closeCompleted = false;
        try {
            this.closeImpl(transferSuccess);
            closeCompleted = true;
        }
        catch (IOException e) {
            try {
                this._monitor.failure(this.getAsSub(), e);
                throw e;
                catch (RuntimeException e2) {
                    this._monitor.failure(this.getAsSub(), e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                try {
                    this._monitor.closed(this.getAsSub(), remoteClose && closeCompleted && oldState == State.OPEN);
                    throw throwable;
                }
                finally {
                    this.unexport();
                }
            }
        }
        try {
            this._monitor.closed(this.getAsSub(), remoteClose && closeCompleted && oldState == State.OPEN);
            return;
        }
        finally {
            this.unexport();
        }
    }

    public final void abort() throws IOException {
        this._state.compareAndSet(State.OPEN, State.ABORTED);
    }

    protected final void checkAborted() throws IOException {
        if (this._state.get() == State.ABORTED) {
            throw new InterruptedIOException("stream server was aborted");
        }
    }

    protected final Object writeReplace() throws ObjectStreamException {
        StreamType replacement = this._writeReplacement;
        if (replacement == null) {
            try {
                this._writeReplacement = replacement = this.export();
            }
            catch (RemoteException e) {
                throw (NotSerializableException)new NotSerializableException(this.getClass().getName() + ": Could not export stream server").initCause(e);
            }
        }
        return replacement;
    }

    private void setRealMonitor(RemoteStreamMonitor<StreamServerType> realMonitor) {
        this._monitor = realMonitor;
    }

    protected abstract void closeImpl(boolean var1) throws IOException;

    protected abstract Object getLock();

    public abstract Class<StreamType> getRemoteClass();

    protected abstract StreamServerType getAsSub();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HardRefMonitor
    implements RemoteStreamMonitor<StreamServerType> {
        private final RemoteStreamMonitor<StreamServerType> _realMonitor;

        public HardRefMonitor(RemoteStreamMonitor<StreamServerType> realMonitor) {
            this._realMonitor = realMonitor;
            _hardRefSet.add(this);
        }

        private void cleanup() {
            _hardRefSet.remove(this);
            RemoteStreamServer.this.setRealMonitor(this._realMonitor);
        }

        @Override
        public void failure(StreamServerType stream, Exception e) {
            this.cleanup();
            this._realMonitor.failure(stream, e);
        }

        @Override
        public void bytesMoved(StreamServerType stream, int numBytes, boolean isReattempt) {
            this.cleanup();
            this._realMonitor.bytesMoved(stream, numBytes, isReattempt);
        }

        @Override
        public void bytesSkipped(StreamServerType stream, long numBytes, boolean isReattempt) {
            this.cleanup();
            this._realMonitor.bytesSkipped(stream, numBytes, isReattempt);
        }

        @Override
        public void localBytesMoved(StreamServerType stream, int numBytes) {
            this.cleanup();
            this._realMonitor.localBytesMoved(stream, numBytes);
        }

        @Override
        public void localBytesSkipped(StreamServerType stream, long numBytes) {
            this.cleanup();
            this._realMonitor.localBytesSkipped(stream, numBytes);
        }

        @Override
        public void closed(StreamServerType stream, boolean clean) {
            this.cleanup();
            this._realMonitor.closed(stream, clean);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        OPEN,
        ABORTED,
        CLOSED;

    }
}

