/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import com.github.davidmoten.geo.GeoHash;
import com.github.davidmoten.geo.LatLong;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.GeoRadiusResponseElement;
import org.apache.geode.redis.internal.HashArea;

public class GeoCoder {
    private static final double EARTH_RADIUS_IN_METERS = 6372797.560856;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf getBulkStringGeoCoordinateArrayResponse(ByteBufAllocator alloc, Collection<LatLong> items) throws CoderException {
        ByteBuf response = alloc.buffer();
        response.writeByte(42);
        ByteBuf tmp = alloc.buffer();
        int size = 0;
        try {
            for (LatLong next : items) {
                if (next == null) {
                    tmp.writeBytes(Coder.bNIL);
                } else {
                    tmp.writeBytes(Coder.getArrayResponse(alloc, Arrays.asList(Double.toString(next.getLon()), Double.toString(next.getLat()))));
                }
                ++size;
            }
            response.writeBytes(Coder.intToBytes(size));
            response.writeBytes(Coder.CRLFar);
            response.writeBytes(tmp);
        }
        finally {
            tmp.release();
        }
        return response;
    }

    public static ByteBuf geoRadiusResponse(ByteBufAllocator alloc, Collection<GeoRadiusResponseElement> list) throws CoderException {
        if (list.isEmpty()) {
            return Coder.getEmptyArrayResponse(alloc);
        }
        ArrayList<Object> responseElements = new ArrayList<Object>();
        for (GeoRadiusResponseElement element : list) {
            String name = element.getName();
            String distStr = "";
            if (element.isShowDist()) {
                distStr = element.getDistFromCenter().toString();
            }
            ArrayList<String> coord = new ArrayList<String>();
            if (element.getCoord().isPresent()) {
                coord.add(Double.toString(element.getCoord().get().getLon()));
                coord.add(Double.toString(element.getCoord().get().getLat()));
            }
            String hash = "";
            if (element.getHash().isPresent()) {
                hash = element.getHash().get();
            }
            if (!(Objects.equals(distStr, "") && coord.isEmpty() && Objects.equals(hash, ""))) {
                ArrayList<Object> elementData = new ArrayList<Object>();
                elementData.add(name);
                if (!Objects.equals(distStr, "")) {
                    elementData.add(distStr);
                }
                if (!coord.isEmpty()) {
                    elementData.add(coord);
                }
                if (!Objects.equals(hash, "")) {
                    elementData.add(hash);
                }
                responseElements.add(elementData);
                continue;
            }
            responseElements.add(name);
        }
        return Coder.getArrayResponse(alloc, responseElements);
    }

    public static LatLong geoPos(String hash) {
        return GeoHash.decodeHash(hash);
    }

    public static double geoDist(String hash1, String hash2) {
        LatLong coord1 = GeoCoder.geoPos(hash1);
        LatLong coord2 = GeoCoder.geoPos(hash2);
        double lat1 = Math.toRadians(coord1.getLat());
        double long1 = Math.toRadians(coord1.getLon());
        double lat2 = Math.toRadians(coord2.getLat());
        double long2 = Math.toRadians(coord2.getLon());
        return GeoCoder.dist(long1, lat1, long2, lat2);
    }

    public static String geohash(byte[] lon, byte[] lat) throws IllegalArgumentException {
        double longitude = Coder.bytesToDouble(lon);
        double latitude = Coder.bytesToDouble(lat);
        return GeoHash.encodeHash(latitude, longitude);
    }

    public static Set<String> geohashSearchAreas(double longitude, double latitude, double radiusMeters) {
        HashArea boundingBox = GeoCoder.boundingBox(longitude, latitude, radiusMeters);
        int steps = Math.max(1, GeoHash.hashLengthToCoverBoundingBox(boundingBox.minlat, boundingBox.maxlon, boundingBox.maxlat, boundingBox.minlon));
        ArrayList<String> extra = new ArrayList<String>();
        if (steps == 1) {
            extra.addAll(GeoHash.neighbours(GeoHash.encodeHash(latitude, longitude, steps)));
        }
        Set<String> areas = GeoHash.coverBoundingBox(boundingBox.maxlat, boundingBox.minlon, boundingBox.minlat, boundingBox.maxlon, steps).getHashes();
        if (!extra.isEmpty()) {
            extra.forEach(ex -> areas.add((String)ex));
        }
        return areas;
    }

    public static HashArea boundingBox(double longitude, double latitude, double radiusMeters) {
        double minlon = longitude - Math.toDegrees(radiusMeters / 6372797.560856 * Math.cos(Math.toRadians(latitude)));
        double maxlon = longitude + Math.toDegrees(radiusMeters / 6372797.560856 * Math.cos(Math.toRadians(latitude)));
        double minlat = latitude - Math.toDegrees(radiusMeters / 6372797.560856);
        double maxlat = latitude + Math.toDegrees(radiusMeters / 6372797.560856);
        return new HashArea(minlon, maxlon, minlat, maxlat);
    }

    public static double dist(double long1, double lat1, double long2, double lat2) {
        double hav = GeoCoder.haversine(lat2 - lat1) + Math.cos(lat1) * Math.cos(lat2) * GeoCoder.haversine(long2 - long1);
        double distAngle = Math.acos(1.0 - 2.0 * hav);
        return 6372797.560856 * distAngle;
    }

    public static double haversine(double rad) {
        return 0.5 * (1.0 - Math.cos(rad));
    }

    public static double parseUnitScale(String unit) throws IllegalArgumentException {
        switch (unit) {
            case "km": {
                return 0.001;
            }
            case "m": {
                return 1.0;
            }
            case "ft": {
                return 3.28084;
            }
            case "mi": {
                return 6.21371E-4;
            }
        }
        throw new IllegalArgumentException();
    }
}

