/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import com.github.davidmoten.geo.LatLong;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class GeoRadiusResponseElement {
    private String name;
    private Optional<LatLong> coord;
    private Double distFromCenter;
    private boolean showDist;
    private Optional<String> hash;

    public String getName() {
        return this.name;
    }

    public Optional<LatLong> getCoord() {
        return this.coord;
    }

    public Double getDistFromCenter() {
        return this.distFromCenter;
    }

    public boolean isShowDist() {
        return this.showDist;
    }

    public Optional<String> getHash() {
        return this.hash;
    }

    public GeoRadiusResponseElement(String n, Optional<LatLong> c, Double d, boolean sh, Optional<String> h) {
        this.name = n;
        this.coord = c;
        this.distFromCenter = d;
        this.showDist = sh;
        this.hash = h;
    }

    public static void sortByDistanceAscending(List<GeoRadiusResponseElement> elements) {
        Collections.sort(elements, Comparator.comparing(GeoRadiusResponseElement::getDistFromCenter));
    }

    public static void sortByDistanceDescending(List<GeoRadiusResponseElement> elements) {
        Collections.sort(elements, Comparator.comparing(x -> -1.0 * x.getDistFromCenter()));
    }
}

