/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.Map;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public class FlushAllExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        if (context.hasTransaction()) {
            throw new UnsupportedOperationInTransactionException();
        }
        for (Map.Entry<String, RedisDataType> e : context.getKeyRegistrar().keyInfos()) {
            try {
                String skey = e.getKey();
                RedisDataType type = e.getValue();
                this.removeEntry(Coder.stringToByteWrapper(skey), type, context);
            }
            catch (EntryDestroyedException e1) {}
        }
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
    }
}

