/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import com.github.davidmoten.geo.LatLong;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.GeoCoder;
import org.apache.geode.redis.internal.GeoRadiusResponseElement;
import org.apache.geode.redis.internal.MemberNotFoundException;
import org.apache.geode.redis.internal.RedisCommandParserException;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.sortedset.GeoRadiusParameters;
import org.apache.geode.redis.internal.executor.sortedset.GeoSortedSetExecutor;

public class GeoRadiusExecutor
extends GeoSortedSetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        GeoRadiusParameters params;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 6) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GEORADIUS command is \"GEORADIUS key longitude latitude radius m|km|ft|mi [WITHCOORD] [WITHDIST] [WITHHASH] [COUNT count] [ASC|DESC]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        try {
            params = new GeoRadiusParameters(keyRegion, commandElems, GeoRadiusParameters.CommandType.GEORADIUS);
        }
        catch (IllegalArgumentException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Either illegal non numeric argument or invalid unit(please use either km/m/ft/mi)"));
            return;
        }
        catch (RedisCommandParserException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GEORADIUS command is \"GEORADIUS key longitude latitude radius m|km|ft|mi [WITHCOORD] [WITHDIST] [WITHHASH] [COUNT count] [ASC|DESC]\""));
            return;
        }
        catch (MemberNotFoundException e) {
            return;
        }
        Set<String> hn = GeoCoder.geohashSearchAreas(params.lon, params.lat, params.radius);
        List<GeoRadiusResponseElement> results = new ArrayList<GeoRadiusResponseElement>();
        for (String neighbor : hn) {
            try {
                List<StructImpl> range = this.getGeoRadiusRange(context, key, neighbor);
                for (StructImpl point : range) {
                    String name = point.get("key").toString();
                    String hash = point.get("value").toString();
                    double dist = GeoCoder.geoDist(params.centerHashPrecise, hash) * params.distScale;
                    if (dist > params.radius * params.distScale) continue;
                    Optional<LatLong> coord = params.withCoord ? Optional.of(GeoCoder.geoPos(hash)) : Optional.empty();
                    Optional<String> hashOpt = params.withHash ? Optional.of(hash) : Optional.empty();
                    results.add(new GeoRadiusResponseElement(name, coord, dist, params.withDist, hashOpt));
                }
            }
            catch (Exception e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), e.getMessage()));
                return;
            }
        }
        if (params.order == GeoRadiusParameters.SortOrder.ASC) {
            GeoRadiusResponseElement.sortByDistanceAscending(results);
        } else if (params.order == GeoRadiusParameters.SortOrder.DESC) {
            GeoRadiusResponseElement.sortByDistanceDescending(results);
        }
        if (params.count != null && params.count < results.size()) {
            results = results.subList(0, params.count);
        }
        this.respondGeoRadius(command, context, results);
    }
}

