/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.asyncqueue.AsyncEvent;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.lucene.internal.LuceneExceptionObserver;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;

public class LuceneEventListener
implements AsyncEventListener {
    private static LuceneExceptionObserver exceptionObserver = exception -> {};
    private InternalCache cache;
    private static final Logger logger = LogService.getLogger();
    private final RepositoryManager repositoryManager;

    public LuceneEventListener(InternalCache cache, RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
        this.cache = cache;
    }

    public void close() {
    }

    void logDebugMessage(String msg, Exception e) {
        logger.debug(msg, (Throwable)e);
    }

    public boolean processEvents(List<AsyncEvent> events) {
        try {
            return this.process(events);
        }
        catch (RuntimeException e) {
            exceptionObserver.onException(e);
            throw e;
        }
        catch (Error e) {
            exceptionObserver.onException(e);
            throw e;
        }
    }

    protected boolean process(List<AsyncEvent> events) {
        Boolean initialPdxReadSerialized = this.cache.getPdxReadSerializedOverride();
        this.cache.setPdxReadSerializedOverride(true);
        HashSet<IndexRepository> affectedRepos = new HashSet<IndexRepository>();
        try {
            for (AsyncEvent event : events) {
                Region region = event.getRegion();
                Object key = event.getKey();
                Object callbackArgument = event.getCallbackArgument();
                IndexRepository repository = this.repositoryManager.getRepository(region, key, callbackArgument);
                Object value = this.getValue(region.getEntry(key));
                if (value != null) {
                    repository.update(key, value);
                } else {
                    repository.delete(key);
                }
                affectedRepos.add(repository);
            }
            for (IndexRepository repo : affectedRepos) {
                repo.commit();
            }
            boolean bl = true;
            return bl;
        }
        catch (RegionDestroyedException | BucketNotFoundException | PrimaryBucketException e) {
            this.logDebugMessage("Bucket not found while saving to lucene index: " + e.getMessage(), (Exception)e);
            boolean bl = false;
            return bl;
        }
        catch (CacheClosedException e) {
            this.logDebugMessage("Unable to save to lucene index, cache has been closed", (Exception)((Object)e));
            boolean bl = false;
            return bl;
        }
        catch (AlreadyClosedException e) {
            this.logDebugMessage("Unable to commit, the lucene index is already closed", (Exception)((Object)e));
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new InternalGemFireError("Unable to save to lucene index", (Throwable)e);
        }
        finally {
            this.cache.setPdxReadSerializedOverride(initialPdxReadSerialized.booleanValue());
        }
    }

    private Object getValue(Region.Entry entry) {
        Object value;
        EntrySnapshot es = (EntrySnapshot)entry;
        try {
            value = es == null ? null : es.getRawValue(true);
        }
        catch (EntryDestroyedException e) {
            value = null;
        }
        return value;
    }

    public static void setExceptionObserver(LuceneExceptionObserver observer) {
        if (observer == null) {
            observer = exception -> {};
        }
        exceptionObserver = observer;
    }

    public static LuceneExceptionObserver getExceptionObserver() {
        return exceptionObserver;
    }
}

