/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.serialization;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.SerializationType;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.TypeConverter;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.JSONFormatterException;
import org.apache.geode.pdx.PdxInstance;

@Experimental
public class JsonPdxConverter
implements TypeConverter<String, PdxInstance> {
    @Override
    public PdxInstance decode(String incoming) throws DecodingException {
        try {
            return JSONFormatter.fromJSON(incoming);
        }
        catch (JSONFormatterException ex) {
            throw new DecodingException("Could not decode JSON-encoded object ", ex);
        }
    }

    @Override
    public String encode(PdxInstance incoming) throws EncodingException {
        try {
            return JSONFormatter.toJSON(incoming);
        }
        catch (JSONFormatterException ex) {
            throw new EncodingException("Could not encode PDX object as JSON", ex);
        }
    }

    @Override
    public SerializationType getSerializationType() {
        return SerializationType.JSON;
    }
}

