/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.List;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.GatewaySenderFunctionArgs;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.logging.log4j.Logger;

public class GatewaySenderCreateFunction
implements InternalFunction<GatewaySenderFunctionArgs> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = GatewaySenderCreateFunction.class.getName();
    @Immutable
    public static final GatewaySenderCreateFunction INSTANCE = new GatewaySenderCreateFunction();

    public void execute(FunctionContext<GatewaySenderFunctionArgs> context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = context.getMemberName();
        GatewaySenderFunctionArgs gatewaySenderCreateArgs = (GatewaySenderFunctionArgs)context.getArguments();
        try {
            GatewaySender createdGatewaySender = this.createGatewaySender(cache, gatewaySenderCreateArgs);
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, CliStrings.format((String)"GatewaySender \"{0}\" created on \"{1}\"", (Object[])new Object[]{createdGatewaySender.getId(), memberNameOrId})));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, (Object)e, null));
        }
    }

    private GatewaySender createGatewaySender(Cache cache, GatewaySenderFunctionArgs gatewaySenderCreateArgs) {
        List<String> gatewayTransportFilters;
        List<String> gatewayEventFilters;
        Boolean isDiskSynchronous;
        String diskStoreName;
        Boolean isPersistenceEnabled;
        Integer dispatcherThreads;
        Integer alertThreshold;
        Integer socketReadTimeout;
        Integer socketBufferSize;
        Boolean enableBatchConflation;
        Integer batchTimeInterval;
        Integer batchSize;
        Integer maxQueueMemory;
        Boolean manualStart;
        GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
        Boolean isParallel = gatewaySenderCreateArgs.isParallel();
        if (isParallel != null) {
            gateway.setParallel(isParallel.booleanValue());
        }
        if ((manualStart = gatewaySenderCreateArgs.isManualStart()) != null) {
            gateway.setManualStart(manualStart.booleanValue());
        }
        if ((maxQueueMemory = gatewaySenderCreateArgs.getMaxQueueMemory()) != null) {
            gateway.setMaximumQueueMemory(maxQueueMemory.intValue());
        }
        if ((batchSize = gatewaySenderCreateArgs.getBatchSize()) != null) {
            gateway.setBatchSize(batchSize.intValue());
        }
        if ((batchTimeInterval = gatewaySenderCreateArgs.getBatchTimeInterval()) != null) {
            gateway.setBatchTimeInterval(batchTimeInterval.intValue());
        }
        if ((enableBatchConflation = gatewaySenderCreateArgs.isBatchConflationEnabled()) != null) {
            gateway.setBatchConflationEnabled(enableBatchConflation.booleanValue());
        }
        if ((socketBufferSize = gatewaySenderCreateArgs.getSocketBufferSize()) != null) {
            gateway.setSocketBufferSize(socketBufferSize.intValue());
        }
        if ((socketReadTimeout = gatewaySenderCreateArgs.getSocketReadTimeout()) != null) {
            gateway.setSocketReadTimeout(socketReadTimeout.intValue());
        }
        if ((alertThreshold = gatewaySenderCreateArgs.getAlertThreshold()) != null) {
            gateway.setAlertThreshold(alertThreshold.intValue());
        }
        if ((dispatcherThreads = gatewaySenderCreateArgs.getDispatcherThreads()) != null) {
            gateway.setDispatcherThreads(dispatcherThreads.intValue());
        }
        if (dispatcherThreads != null && dispatcherThreads > 1) {
            String orderPolicy = gatewaySenderCreateArgs.getOrderPolicy();
            gateway.setOrderPolicy(GatewaySender.OrderPolicy.valueOf((String)orderPolicy));
        }
        if ((isPersistenceEnabled = gatewaySenderCreateArgs.isPersistenceEnabled()) != null) {
            gateway.setPersistenceEnabled(isPersistenceEnabled.booleanValue());
        }
        if ((diskStoreName = gatewaySenderCreateArgs.getDiskStoreName()) != null) {
            gateway.setDiskStoreName(diskStoreName);
        }
        if ((isDiskSynchronous = gatewaySenderCreateArgs.isDiskSynchronous()) != null) {
            gateway.setDiskSynchronous(isDiskSynchronous.booleanValue());
        }
        if ((gatewayEventFilters = gatewaySenderCreateArgs.getGatewayEventFilter()) != null) {
            for (String gatewayEventFilter : gatewayEventFilters) {
                Class gatewayEventFilterKlass = ManagementUtils.forName((String)gatewayEventFilter, (String)"gateway-event-filter");
                gateway.addGatewayEventFilter((GatewayEventFilter)CliUtil.newInstance(gatewayEventFilterKlass, "gateway-event-filter"));
            }
        }
        if ((gatewayTransportFilters = gatewaySenderCreateArgs.getGatewayTransportFilter()) != null) {
            for (String gatewayTransportFilter : gatewayTransportFilters) {
                Class gatewayTransportFilterKlass = ManagementUtils.forName((String)gatewayTransportFilter, (String)"gateway-transport-filter");
                gateway.addGatewayTransportFilter((GatewayTransportFilter)CliUtil.newInstance(gatewayTransportFilterKlass, "gateway-transport-filter"));
            }
        }
        return gateway.create(gatewaySenderCreateArgs.getId(), gatewaySenderCreateArgs.getRemoteDistributedSystemId().intValue());
    }

    public String getId() {
        return ID;
    }
}

