/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ResourceEventsListener;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.geode.redis.internal.GeodeRedisServer;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.NullRedisData;
import org.apache.geode.redis.internal.data.RedisHash;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.data.RedisSet;
import org.apache.geode.redis.internal.data.RedisString;
import org.apache.geode.redis.internal.executor.string.SetOptions;
import org.apache.logging.log4j.Logger;

public class GeodeRedisService
implements CacheService,
ResourceEventsListener {
    private static final Logger logger = LogService.getLogger();
    private GeodeRedisServer redisServer;
    private InternalCache cache;

    public boolean init(Cache cache) {
        this.cache = (InternalCache)cache;
        if (!this.cache.getInternalDistributedSystem().getConfig().getRedisEnabled()) {
            return false;
        }
        this.cache.getInternalDistributedSystem().addResourceListener((ResourceEventsListener)this);
        this.registerDataSerializables();
        return true;
    }

    private void registerDataSerializables() {
        InternalDataSerializer.getDSFIDSerializer().registerDSFID(160, RedisKey.class);
        InternalDataSerializer.getDSFIDSerializer().registerDSFID(70, ByteArrayWrapper.class);
        InternalDataSerializer.getDSFIDSerializer().registerDSFID(2186, RedisSet.class);
        InternalDataSerializer.getDSFIDSerializer().registerDSFID(2187, RedisString.class);
        InternalDataSerializer.getDSFIDSerializer().registerDSFID(2188, RedisHash.class);
        InternalDataSerializer.getDSFIDSerializer().registerDSFID(2189, NullRedisData.class);
        InternalDataSerializer.getDSFIDSerializer().registerDSFID(2190, SetOptions.class);
    }

    public void close() {
        this.stopRedisServer();
    }

    public void handleEvent(ResourceEvent event, Object resource) {
        if (event.equals((Object)ResourceEvent.CLUSTER_CONFIGURATION_APPLIED) && resource == this.cache) {
            this.startRedisServer(this.cache);
        }
    }

    private void startRedisServer(InternalCache cache) {
        InternalDistributedSystem system = cache.getInternalDistributedSystem();
        if (system.getConfig().getRedisEnabled()) {
            int port = system.getConfig().getRedisPort();
            String bindAddress = system.getConfig().getRedisBindAddress();
            assert (bindAddress != null);
            logger.info(String.format("Starting GeodeRedisServer on bind address %s on port %s", bindAddress, port));
            this.redisServer = new GeodeRedisServer(bindAddress, port, cache);
        }
    }

    private void stopRedisServer() {
        if (this.redisServer != null) {
            this.redisServer.shutdown();
        }
    }

    public Class<? extends CacheService> getInterface() {
        return GeodeRedisService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }

    public int getPort() {
        return this.redisServer.getPort();
    }

    public void setEnableUnsupported(boolean unsupported) {
        this.redisServer.setAllowUnsupportedCommands(unsupported);
    }
}

