/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.ParameterRequirements;

import org.apache.geode.redis.internal.ParameterRequirements.ParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.RedisParametersMismatchException;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class EvenParameterRequirements
implements ParameterRequirements {
    private final String errorMessage;

    public EvenParameterRequirements() {
        this.errorMessage = null;
    }

    public EvenParameterRequirements(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void checkParameters(Command command, ExecutionHandlerContext executionHandlerContext) {
        if (!this.isEven(command.getProcessedCommand().size())) {
            throw new RedisParametersMismatchException(this.getErrorMessage(command));
        }
    }

    private boolean isEven(int n) {
        return n % 2 == 0;
    }

    private String getErrorMessage(Command command) {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return command.wrongNumberOfArgumentsErrorMessage();
    }
}

