/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.ParameterRequirements;

import org.apache.geode.redis.internal.ParameterRequirements.ParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.RedisParametersMismatchException;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class SlowlogParameterRequirements
implements ParameterRequirements {
    @Override
    public void checkParameters(Command command, ExecutionHandlerContext context) {
        int numberOfArguments = command.getProcessedCommand().size();
        if (numberOfArguments < 2) {
            throw new RedisParametersMismatchException(command.wrongNumberOfArgumentsErrorMessage());
        }
        if (numberOfArguments == 2) {
            this.confirmKnownSubcommands(command);
        } else if (numberOfArguments == 3) {
            this.confirmArgumentsToGetSubcommand(command);
        } else {
            throw new RedisParametersMismatchException(String.format("Unknown subcommand or wrong number of arguments for '%s'. Try SLOWLOG HELP.", command.getStringKey()));
        }
    }

    private void confirmKnownSubcommands(Command command) {
        if (!(command.getStringKey().toLowerCase().equals("reset") || command.getStringKey().toLowerCase().equals("len") || command.getStringKey().toLowerCase().equals("get"))) {
            throw new RedisParametersMismatchException(String.format("Unknown subcommand or wrong number of arguments for '%s'. Try SLOWLOG HELP.", command.getStringKey()));
        }
    }

    private void confirmArgumentsToGetSubcommand(Command command) {
        if (!command.getStringKey().toLowerCase().equals("get")) {
            throw new RedisParametersMismatchException(String.format("Unknown subcommand or wrong number of arguments for '%s'. Try SLOWLOG HELP.", command.getStringKey()));
        }
        try {
            Long.parseLong(new String(command.getProcessedCommand().get(2)));
        }
        catch (NumberFormatException nex) {
            throw new RedisParametersMismatchException("value is not an integer or out of range");
        }
    }
}

