/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.NullRedisDataStructures;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisDataType;
import org.apache.geode.redis.internal.data.RedisDataTypeMismatchException;
import org.apache.geode.redis.internal.data.RedisHash;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.data.RedisSet;
import org.apache.geode.redis.internal.data.RedisString;
import org.apache.geode.redis.internal.executor.StripedExecutor;
import org.apache.geode.redis.internal.statistics.RedisStats;

public class CommandHelper {
    private final Region<RedisKey, RedisData> region;
    private final RedisStats redisStats;
    private final StripedExecutor stripedExecutor;

    public Region<RedisKey, RedisData> getRegion() {
        return this.region;
    }

    public RedisStats getRedisStats() {
        return this.redisStats;
    }

    public StripedExecutor getStripedExecutor() {
        return this.stripedExecutor;
    }

    public CommandHelper(Region<RedisKey, RedisData> region, RedisStats redisStats, StripedExecutor stripedExecutor) {
        this.region = region;
        this.redisStats = redisStats;
        this.stripedExecutor = stripedExecutor;
    }

    RedisData getRedisData(RedisKey key) {
        return this.getRedisData(key, NullRedisDataStructures.NULL_REDIS_DATA);
    }

    RedisData getRedisData(RedisKey key, RedisData notFoundValue) {
        RedisData result = (RedisData)this.region.get((Object)key);
        if (result != null && result.hasExpired()) {
            result.doExpiration(this, key);
            result = null;
        }
        if (result == null) {
            return notFoundValue;
        }
        return result;
    }

    RedisSet getRedisSet(RedisKey key, boolean updateStats) {
        RedisData redisData = this.getRedisData(key, NullRedisDataStructures.NULL_REDIS_SET);
        if (updateStats) {
            if (redisData == NullRedisDataStructures.NULL_REDIS_SET) {
                this.redisStats.incKeyspaceMisses();
            } else {
                this.redisStats.incKeyspaceHits();
            }
        }
        return this.checkSetType(redisData);
    }

    private RedisSet checkSetType(RedisData redisData) {
        if (redisData == null) {
            return null;
        }
        if (redisData.getType() != RedisDataType.REDIS_SET) {
            throw new RedisDataTypeMismatchException("Operation against a key holding the wrong kind of value");
        }
        return (RedisSet)redisData;
    }

    RedisHash getRedisHash(RedisKey key, boolean updateStats) {
        RedisData redisData = this.getRedisData(key, NullRedisDataStructures.NULL_REDIS_HASH);
        if (updateStats) {
            if (redisData == NullRedisDataStructures.NULL_REDIS_HASH) {
                this.redisStats.incKeyspaceMisses();
            } else {
                this.redisStats.incKeyspaceHits();
            }
        }
        return this.checkHashType(redisData);
    }

    private RedisHash checkHashType(RedisData redisData) {
        if (redisData == null) {
            return null;
        }
        if (redisData.getType() != RedisDataType.REDIS_HASH) {
            throw new RedisDataTypeMismatchException("Operation against a key holding the wrong kind of value");
        }
        return (RedisHash)redisData;
    }

    private RedisString checkStringType(RedisData redisData, boolean ignoreTypeMismatch) {
        if (redisData == null) {
            return null;
        }
        if (redisData.getType() != RedisDataType.REDIS_STRING) {
            if (ignoreTypeMismatch) {
                return NullRedisDataStructures.NULL_REDIS_STRING;
            }
            throw new RedisDataTypeMismatchException("Operation against a key holding the wrong kind of value");
        }
        return (RedisString)redisData;
    }

    RedisString getRedisString(RedisKey key, boolean updateStats) {
        RedisData redisData = this.getRedisData(key, NullRedisDataStructures.NULL_REDIS_STRING);
        if (updateStats) {
            if (redisData == NullRedisDataStructures.NULL_REDIS_STRING) {
                this.redisStats.incKeyspaceMisses();
            } else {
                this.redisStats.incKeyspaceHits();
            }
        }
        return this.checkStringType(redisData, false);
    }

    RedisString getRedisStringIgnoringType(RedisKey key, boolean updateStats) {
        RedisData redisData = this.getRedisData(key, NullRedisDataStructures.NULL_REDIS_STRING);
        if (updateStats) {
            if (redisData == NullRedisDataStructures.NULL_REDIS_STRING) {
                this.redisStats.incKeyspaceMisses();
            } else {
                this.redisStats.incKeyspaceHits();
            }
        }
        return this.checkStringType(redisData, true);
    }

    RedisString setRedisString(RedisKey key, ByteArrayWrapper value) {
        RedisString result;
        RedisData redisData = this.getRedisData(key);
        if (redisData.isNull() || redisData.getType() != RedisDataType.REDIS_STRING) {
            result = new RedisString(value);
        } else {
            result = (RedisString)redisData;
            result.set(value);
        }
        this.region.put((Object)key, (Object)result);
        return result;
    }
}

