/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.CommandHelper;
import org.apache.geode.redis.internal.data.RedisDataCommandsFunctionExecutor;
import org.apache.geode.redis.internal.data.RedisHash;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.hash.RedisHashCommands;

public class RedisHashCommandsFunctionExecutor
extends RedisDataCommandsFunctionExecutor
implements RedisHashCommands {
    public RedisHashCommandsFunctionExecutor(CommandHelper helper) {
        super(helper);
    }

    private RedisHash getRedisHash(RedisKey key, boolean updateStats) {
        return this.helper.getRedisHash(key, updateStats);
    }

    @Override
    public int hset(RedisKey key, List<ByteArrayWrapper> fieldsToSet, boolean NX) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, false).hset(this.getRegion(), key, fieldsToSet, NX));
    }

    @Override
    public int hdel(RedisKey key, List<ByteArrayWrapper> fieldsToRemove) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, false).hdel(this.getRegion(), key, fieldsToRemove));
    }

    @Override
    public Collection<ByteArrayWrapper> hgetall(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, true).hgetall());
    }

    @Override
    public int hexists(RedisKey key, ByteArrayWrapper field) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, true).hexists(field));
    }

    @Override
    public ByteArrayWrapper hget(RedisKey key, ByteArrayWrapper field) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, true).hget(field));
    }

    @Override
    public int hlen(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, true).hlen());
    }

    @Override
    public int hstrlen(RedisKey key, ByteArrayWrapper field) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, true).hstrlen(field));
    }

    @Override
    public List<ByteArrayWrapper> hmget(RedisKey key, List<ByteArrayWrapper> fields) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, true).hmget(fields));
    }

    @Override
    public Collection<ByteArrayWrapper> hvals(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, true).hvals());
    }

    @Override
    public Collection<ByteArrayWrapper> hkeys(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, true).hkeys());
    }

    @Override
    public Pair<Integer, List<Object>> hscan(RedisKey key, Pattern matchPattern, int count, int cursor, UUID clientID) {
        return (Pair)this.stripedExecute(key, () -> this.getRedisHash(key, true).hscan(clientID, matchPattern, count, cursor));
    }

    @Override
    public long hincrby(RedisKey key, ByteArrayWrapper field, long increment) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, false).hincrby(this.getRegion(), key, field, increment));
    }

    @Override
    public BigDecimal hincrbyfloat(RedisKey key, ByteArrayWrapper field, BigDecimal increment) {
        return this.stripedExecute(key, () -> this.getRedisHash(key, false).hincrbyfloat(this.getRegion(), key, field, increment));
    }
}

